/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.FunctionCall;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.OutputDirective;

public class XTextDocumentQueryHelper {
    public static Optional<OutputDirective> getOutputDirective(IXtextDocument document) {
        return Optional.ofNullable((OutputDirective)document.readOnly((IUnitOfWork)new LoadOutputDirectiveWork()));
    }

    public static Optional<EObject> getLookupFunctionCall(IXtextDocument document) {
        return (Optional)document.readOnly((IUnitOfWork)new LoadLookupFunctionCallWork());
    }

    private static final class LoadLookupFunctionCallWork
    implements IUnitOfWork<Optional<EObject>, XtextResource> {
        private static final String LOOKUP_FUNCTION_NAME = "lookup";

        private LoadLookupFunctionCallWork() {
        }

        public Optional<EObject> exec(XtextResource state) throws Exception {
            TreeIterator eAllContents = state.getAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof FunctionCall) || !LOOKUP_FUNCTION_NAME.equals(((FunctionCall)eObject).getName())) continue;
                return Optional.of(eObject);
            }
            return Optional.empty();
        }
    }

    private static final class LoadOutputDirectiveWork
    implements IUnitOfWork<OutputDirective, XtextResource> {
        private LoadOutputDirectiveWork() {
        }

        public OutputDirective exec(XtextResource state) throws Exception {
            return LoadOutputDirectiveWork.loadOutputDirective(state);
        }

        private static OutputDirective loadOutputDirective(XtextResource state) {
            EList directives;
            Header header;
            Document document;
            Body body;
            EList contents;
            if (state != null && !(contents = state.getContents()).isEmpty() && contents.get(0) instanceof Document && (body = (document = (Document)contents.get(0)).getBody()) != null && (header = body.getHeader()) != null && (directives = header.getDirectives()) != null) {
                for (Directive directive : directives) {
                    if (!(directive instanceof OutputDirective)) continue;
                    return (OutputDirective)directive;
                }
            }
            return null;
        }
    }
}

