/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import org.eclipse.jface.viewers.StyledString;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.dfl.ui.graphical.livedata.ILiveDataProvider;
import org.mule.tooling.dfl.ui.utils.SimpleLiveDataProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class WeaveGraphicalTreeNode<T>
extends GraphicalTreeNode<T> {
    private ILiveDataProvider provider = new SimpleLiveDataProvider();

    public WeaveGraphicalTreeNode(String label, String description, T model, IGraphicalChildrenProvider<T> factory) {
        super(label, description, model, factory);
    }

    public WeaveGraphicalTreeNode(String label, String description, T model, IGraphicalChildrenProvider<T> factory, ILiveDataProvider provider) {
        super(label, description, model, factory);
        this.provider = provider;
    }

    public WeaveGraphicalTreeNode(GraphicalTreeNode<?> parent, String label, String description, T model, IGraphicalChildrenProvider<T> factory) {
        super(parent, label, description, model, factory);
    }

    public WeaveGraphicalTreeNode(GraphicalTreeNode<?> parent, String label, String description, T model, IGraphicalChildrenProvider<T> factory, ILiveDataProvider provider) {
        super(parent, label, description, model, factory);
        this.provider = provider;
    }

    public ILiveDataProvider getLiveDataProvider() {
        return this.provider;
    }

    public String getSuffix() {
        return this.getLiveDataProvider().getLiveData().orElse("");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        result = 31 * result + this.getLevel();
        result = 31 * result + (this.getModel() == null ? 0 : this.modelHashCode());
        result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
        return result;
    }

    private int modelHashCode() {
        Object model = this.getModel();
        if (model instanceof MetadataType) {
            model = MetadataTypeProxy.unwrapIfProxy((MetadataType)((MetadataType)model));
        }
        return System.identityHashCode(model);
    }

    public StyledString.Styler getLiveDataSytle() {
        return this.getLiveDataProvider().getStyle();
    }
}

