/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.ui.internal.DflActivator;
import org.mule.tooling.dfl.ui.utils.PluginUtils;
import org.mule.tooling.utils.SilentRunner;
import org.osgi.framework.Bundle;

public final class ResourcesHelper {
    public static final Comparator<File> compareByTypeAndName = new FileComparator();

    private ResourcesHelper() {
    }

    public static File getFile(String path) throws IOException {
        File bundle = FileLocator.getBundleFile((Bundle)DflActivator.getInstance().getBundle());
        return new File(bundle, path);
    }

    public static File toFile(IFile file) {
        final URI uri = file.isLinked() ? file.getRawLocationURI() : file.getLocationURI();
        return (File)SilentRunner.run((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }, null);
    }

    public static boolean isUniqueName(IFolder folder, String newFileName, String extension) {
        if (newFileName.toLowerCase().endsWith(extension)) {
            return !folder.getFile(newFileName).exists();
        }
        return !folder.getFile(newFileName + extension).exists();
    }

    public static String uniqueOSFileName(IFolder folder, String prefix, String extension) {
        Object result = prefix.toLowerCase();
        int index = 1;
        while (folder.getFile((String)result + extension).getLocation().toFile().exists()) {
            result = prefix + "_" + index;
            ++index;
        }
        return (String)result + extension;
    }

    public static void createFile(IFile file, String content) {
        if (content == null) {
            throw new InvalidParameterException("Content cannot be null");
        }
        ResourcesHelper.createFile(file, content.getBytes());
    }

    public static void createFile(IFile file, byte[] bytes) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream source = new ByteArrayInputStream(bytes);){
                file.create((InputStream)source, 0, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PluginUtils.logError("Error reading file", e);
        }
    }

    public static String readFileContent(String fileRelativePath) {
        try {
            return CoreUtils.readInputStreamContent((InputStream)new FileInputStream(ResourcesHelper.getFile(fileRelativePath)));
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Error reading file", (Throwable)e);
            return "";
        }
    }

    public static List<IResource> getDFLFiles(IMuleProject project) {
        return CoreUtils.filterResources((IMuleProject)project, (IResourceVisitor)new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                return resource instanceof IFile && resource.getName().endsWith(".dwl");
            }
        });
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return file1.isDirectory() ^ file2.isDirectory() ? (file1.isDirectory() ? 1 : -1) : file1.getName().compareTo(file2.getName());
        }
    }
}

