/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.ui.widgets.script.SharedColors;

public class Notifier {
    private static final SharedColors colors = new SharedColors();
    private static final Color FOREGROUND_COLOR = Display.getDefault().getSystemColor(15);
    private static final Color WHITE_COLOR = colors.getColor(new RGB(250, 250, 250));
    private static final Color GREEN_BACKGROUND_COLOR = colors.getColor(new RGB(151, 223, 96));
    private static final Color YELLOW_BACKGROUND_COLOR = colors.getColor(new RGB(252, 242, 108));
    private static final Color RED_BACKGROUND_COLOR = colors.getColor(new RGB(247, 107, 114));
    private static final Color BACKGROUND_COLOR = colors.getColor(new RGB(80, 80, 80));
    private static final int DISPLAY_TIME = 800;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private static final int POP_UP_DEFAULT_WIDTH = 200;
    private static final int POP_UP_DEFAULT_HEIGHT = 20;
    private Shell _shell;
    private Control displayControl;
    private Control disposeControl;

    public Notifier(Control displayControl, Control disposeControl) {
        this.displayControl = displayControl;
        this.disposeControl = disposeControl;
    }

    public void ok(String message) {
        if (this.displayControl != null && this.displayControl.isDisposed()) {
            return;
        }
        if (this._shell != null && !this._shell.isDisposed()) {
            Notifier.fadeOut(this._shell);
        }
        this.createNotificationPopUp(message, GREEN_BACKGROUND_COLOR, FOREGROUND_COLOR, JFaceResources.getFontRegistry().getBold(""));
    }

    public void warning(String message) {
        if (this.displayControl != null && this.displayControl.isDisposed()) {
            return;
        }
        if (this._shell != null && !this._shell.isDisposed()) {
            Notifier.fadeOut(this._shell);
        }
        this.createNotificationPopUp(message, YELLOW_BACKGROUND_COLOR, FOREGROUND_COLOR, JFaceResources.getFontRegistry().getBold(""));
    }

    public void error(String message) {
        if (this.displayControl != null && this.displayControl.isDisposed()) {
            return;
        }
        if (this._shell != null && !this._shell.isDisposed()) {
            Notifier.fadeOut(this._shell);
        }
        this.createNotificationPopUp(message, RED_BACKGROUND_COLOR, FOREGROUND_COLOR, JFaceResources.getFontRegistry().getBold(""));
    }

    private void createNotificationPopUp(String message, Color backgroundColor, Color foregroundColor, Font font) {
        this._shell = new Shell(Display.getDefault().getActiveShell(), 524296);
        this._shell.setLayout((Layout)new FillLayout());
        this._shell.setForeground(foregroundColor);
        this._shell.setBackground(backgroundColor);
        this._shell.setBackgroundMode(1);
        Composite inner = new Composite((Composite)this._shell, 0);
        GridLayoutFactory.fillDefaults().margins(4, 4).applyTo(inner);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)inner);
        Label text = new Label(inner, 64);
        GridDataFactory.fillDefaults().applyTo((Control)text);
        text.setFont(font);
        text.setText(message);
        this._shell.setSize(200, 20);
        this._shell.setLocation(this.getLocation());
        this._shell.setAlpha(0);
        this._shell.setVisible(true);
        Notifier.fadeIn(this._shell);
    }

    public void createPopUp(String message) {
        Shell displayShell = new Shell(Display.getDefault().getActiveShell(), 524296);
        displayShell.setLayout((Layout)new FillLayout());
        displayShell.setForeground(WHITE_COLOR);
        Composite inner = new Composite((Composite)displayShell, 0);
        inner.setBackground(BACKGROUND_COLOR);
        GridLayoutFactory.fillDefaults().margins(4, 4).applyTo(inner);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)inner);
        Label text = new Label(inner, 64);
        GridDataFactory.fillDefaults().applyTo((Control)text);
        text.setFont(JFaceResources.getFontRegistry().getBold(""));
        text.setForeground(WHITE_COLOR);
        text.setText(message);
        displayShell.setSize(200, 20);
        displayShell.setLocation(this.getLocation());
        displayShell.setAlpha(0);
        displayShell.setVisible(true);
        this.fadeInUntilClick(displayShell);
    }

    private Point getLocation() {
        if (this.displayControl != null) {
            Point location = this.getControlLocation(this.displayControl);
            Rectangle bounds = this.displayControl.getBounds();
            return new Point(location.x, location.y + bounds.height - 20 - 20);
        }
        Rectangle clientArea = Display.getDefault().getClientArea();
        int startX = clientArea.x + clientArea.width - 200 - 10;
        int startY = clientArea.y + clientArea.height - 20 - 10;
        return new Point(startX, startY);
    }

    private Point getControlLocation(Control control) {
        Point resp = control.getLocation();
        Control actual = control;
        while (actual.getParent() != null) {
            Composite parent = actual.getParent();
            Point pLocation = parent.getLocation();
            resp.x += pLocation.x;
            resp.y += pLocation.y;
            actual = parent;
        }
        return resp;
    }

    private static void fadeIn(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur += 30) > 225) {
                        _shell.setAlpha(225);
                        Notifier.startTimer(_shell);
                        return;
                    }
                    _shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
    }

    private void fadeInUntilClick(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur += 30) > 225) {
                        _shell.setAlpha(225);
                        return;
                    }
                    _shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
        this.waitUntilClick(_shell);
    }

    private void waitUntilClick(final Shell _shell) {
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Notifier.fadeOut(_shell);
            }
        };
        this.disposeControl.getDisplay().addListener(10, listener);
        this.disposeControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Notifier.fadeOut(_shell);
                Notifier.this.disposeControl.getDisplay().removeListener(10, listener);
            }
        });
    }

    private static void startTimer(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    Notifier.fadeOut(_shell);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(800, run);
    }

    private static void fadeOut(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur -= 8) <= 0) {
                        _shell.setAlpha(0);
                        _shell.dispose();
                        return;
                    }
                    _shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        Display.getDefault().timerExec(50, run);
    }
}

