/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.dfl.ui.internal.DflActivator;
import org.osgi.framework.Bundle;

public final class ImagesHelper {
    public static final String IMG_FX = "fx-16x16.png";
    public static final String IMG_FX_BIG = "fx-32x32.png";
    public static final String IMG_FX_BROWSER = "fx-browser.png";
    public static final String IMG_CLEAR_ASSIGNMENT = "delete-assignment.png";
    public static final String IMG_EDIT_ASSIGNMENT = "edit-assignment.png";
    public static final String IMG_IMPORT = "import.png";
    public static final String IMG_ERROR = "icons/error.png";
    public static final String IMG_FILTER = "icons/filter.png";
    public static final String IMG_EDIT_INPUT = "icons/edit_input.png";
    public static final String IMG_LIGHT = "icons/light.png";
    public static final String IMG_ERROR_MESSAGE = "icons/error_message.png";
    public static final String IMG_EMPTY_MESSAGE = "icons/empty_message.png";
    public static final String IMG_ADD_TARGET = "icons/add_target.png";
    public static final String IMG_EDIT_TARGET = "icons/edit_target.png";
    public static final String IMG_DELETE_TARGET = "icons/remove_target.png";

    private ImagesHelper() {
    }

    public static Image getImage(String path) {
        Bundle bundle = DflActivator.getInstance().getBundle();
        String key = bundle.getSymbolicName() + path;
        Image image = JFaceResources.getImage((String)key);
        if (image == null) {
            JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)bundle.getEntry(path)));
            image = JFaceResources.getImage((String)key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Bundle bundle = DflActivator.getInstance().getBundle();
        String key = bundle.getSymbolicName() + path;
        ImageDescriptor desc = JFaceResources.getImageRegistry().getDescriptor(key);
        if (desc == null) {
            desc = ImageDescriptor.createFromURL((URL)bundle.getEntry(path));
            JFaceResources.getImageRegistry().put(key, desc);
        }
        return desc;
    }

    public static Image getInternalImage(String symbolicName) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(symbolicName);
    }

    public static ImageDescriptor getInternalImageDescriptor(String symbolicName) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(symbolicName);
    }
}

