/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.mule.tooling.core.model.IMuleProject;

public class FlatFileSchemaUtils {
    public static void fixSchemaPathIsRequired(IMuleProject muleProject, Map<String, ? super String> readerProperties) {
        String schemaPathObj = readerProperties.get("schemaPath");
        if (schemaPathObj == null || !(schemaPathObj instanceof String)) {
            return;
        }
        String schemaPath = schemaPathObj;
        if (StringUtils.isNotBlank((String)schemaPath)) {
            Path originalSchemaPath = Paths.get(schemaPath, new String[0]);
            IFolder muleResourcesFolder = muleProject.getMuleResourcesFolder();
            Path abstolutePathToResourceFolder = muleResourcesFolder.getLocation().toFile().toPath();
            int totalSegments = originalSchemaPath.getNameCount();
            int segmentsFromBack = 1;
            while (totalSegments - segmentsFromBack >= 0) {
                Path candidatePath = originalSchemaPath.subpath(totalSegments - segmentsFromBack, totalSegments);
                Path pathRelativeToProject = abstolutePathToResourceFolder.resolve(candidatePath);
                if (pathRelativeToProject.toFile().exists()) {
                    readerProperties.put("schemaPath", pathRelativeToProject.toString());
                    break;
                }
                ++segmentsFromBack;
            }
        }
    }
}

