/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.weave.engine.ModuleOption;

public class DwMetadataUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String ENCODING_OPTION = "encoding";

    public static boolean isPojo(MetadataType metadataType) {
        return metadataType instanceof ObjectType && MetadataFormat.JAVA.equals((Object)metadataType.getMetadataFormat());
    }

    public static <T> Optional<T> fromOptional(Optional<T> optional) {
        return optional != null && optional.isPresent() ? Optional.of(optional.get()) : Optional.empty();
    }

    public static Map<String, Object> getWriterProperties(MetadataType model) {
        HashMap<String, Object> writerProperties = new HashMap<String, Object>();
        Map readerProperties = MetadataTypeHelper.getReaderProperties((MetadataType)model);
        Map<String, ModuleOption> writerPropertiesDefinition = WeaveUIModuleManager.getModuleByMetaDataModel(model).getWriterProperties(model);
        for (Map.Entry<String, ModuleOption> entry : writerPropertiesDefinition.entrySet()) {
            String key = entry.getKey();
            if (!readerProperties.containsKey(key)) continue;
            String value = (String)readerProperties.get(key);
            ModuleOption writerOption = entry.getValue();
            if (writerOption.getType() == "String") {
                writerProperties.put(key, value);
                continue;
            }
            if (writerOption.getType() == "Boolean") {
                writerProperties.put(key, Boolean.parseBoolean(value));
                continue;
            }
            if (writerOption.getType() == "Number") {
                writerProperties.put(key, Integer.parseInt(value));
                continue;
            }
            if (!ENCODING_OPTION.equals(writerOption.getName())) continue;
            writerProperties.put(ENCODING_OPTION, DEFAULT_ENCODING);
        }
        return writerProperties;
    }

    public static Map<String, Object> getReaderProperties(MetadataType model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map readerProperties = MetadataTypeHelper.getReaderProperties((MetadataType)model);
        Map<String, ModuleOption> readerPropertiesDefinition = WeaveUIModuleManager.getModuleByMetaDataModel(model).getReaderProperties(model);
        for (Map.Entry<String, ModuleOption> entry : readerPropertiesDefinition.entrySet()) {
            String key = entry.getKey();
            if (!readerProperties.containsKey(key)) continue;
            String value = (String)readerProperties.get(key);
            ModuleOption readerOption = entry.getValue();
            if (readerOption.getType() == "String") {
                result.put(key, value);
                continue;
            }
            if (readerOption.getType() == "Boolean") {
                result.put(key, Boolean.parseBoolean(value));
                continue;
            }
            if (readerOption.getType() == "Number") {
                result.put(key, Integer.parseInt(value));
                continue;
            }
            if (!ENCODING_OPTION.equals(readerOption.getName())) continue;
            result.put(ENCODING_OPTION, DEFAULT_ENCODING);
        }
        return result;
    }
}

