/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.scafflod;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.ui.scafflod.LevelScaffoldingFilter;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;
import org.mule.tooling.dfl.ui.utils.FlatFileSchemaUtils;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class WeaveMetadataTypeScaffoldingService {
    private static final int WORK = 4;

    public static WeaveMetadataTypeScaffoldingService getInstance() {
        return LazyHolder.weaveMetadataTypeScaffoldig;
    }

    public byte[] scaffoldSampleData(IMuleProject muleProject, MetadataType model) {
        return this.scaffoldSampleData(muleProject, model, (IProgressMonitor)new NullProgressMonitor());
    }

    public byte[] scaffoldSampleData(IMuleProject muleProject, MetadataType model, IProgressMonitor progress) {
        byte[] result;
        Map<String, Object> writerProperties = DwMetadataUtils.getWriterProperties(model);
        FlatFileSchemaUtils.fixSchemaPathIsRequired(muleProject, writerProperties);
        SubMonitor scaffoldingMonitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        scaffoldingMonitor.setTaskName("Generating Sample Data: ");
        scaffoldingMonitor.subTask("Scaffolding...");
        DataWeaveLanguageService dataWeaveLanguage = DataWeaveLanguageService.getInstance(muleProject);
        MetadataFormat metadataFormat = model.getMetadataFormat();
        String mimetype = (String)metadataFormat.getValidMimeTypes().iterator().next();
        scaffoldingMonitor.worked(1);
        String dwCode = this.scaffoldSampleData(dataWeaveLanguage, model, mimetype, writerProperties);
        scaffoldingMonitor.worked(1);
        scaffoldingMonitor.subTask("Executing Weave Engine ...");
        IWeaveUIModule moduleByMetaDataModel = WeaveUIModuleManager.getModuleByMetaDataModel(model);
        String sampleDataMimeType = moduleByMetaDataModel.getSampleDataMimeType();
        scaffoldingMonitor.worked(1);
        if (sampleDataMimeType.equals("application/dw")) {
            scaffoldingMonitor.worked(1);
            result = dwCode.toString().getBytes(IMuleResources.DEFAULT_CHARSET);
        } else if (sampleDataMimeType.equalsIgnoreCase("application/flatfile")) {
            result = "".getBytes();
        } else {
            DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
            Object content = dataWeaveScriptingEngine.compile(dwCode).write(new ScriptingBindings()).getContent();
            scaffoldingMonitor.worked(1);
            if (content instanceof InputStream) {
                try {
                    Throwable throwable = null;
                    Object var16_17 = null;
                    try (InputStream is = (InputStream)content;){
                        result = IOUtils.toByteArray((InputStream)is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    result = new byte[]{};
                }
            } else {
                result = content.toString().getBytes(IMuleResources.DEFAULT_CHARSET);
            }
        }
        progress.done();
        return result;
    }

    private String scaffoldSampleData(DataWeaveLanguageService dataWeaveLanguage, MetadataType model, String mimetype, Map<String, Object> writerProperties) {
        IPreferenceStore preferenceStore = DFLExtendedActivator.getInstance().getPreferenceStore();
        if (preferenceStore.getBoolean("dfl.scaffolding.level")) {
            return dataWeaveLanguage.scaffoldSampleData(model, mimetype, writerProperties);
        }
        int levels = preferenceStore.getInt("dfl.scaffolding.level.number");
        return dataWeaveLanguage.scaffoldSampleData(model, mimetype, writerProperties, new LevelScaffoldingFilter(levels));
    }

    private static class LazyHolder {
        static final WeaveMetadataTypeScaffoldingService weaveMetadataTypeScaffoldig = new WeaveMetadataTypeScaffoldingService();

        private LazyHolder() {
        }
    }
}

