/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.scafflod;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.dfl.dFL.AnyDateLiteral;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.IntersectionTypeExpression;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.NullLiteral;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.RealLiteral;
import org.mule.tooling.dfl.dFL.Schema;
import org.mule.tooling.dfl.dFL.SchemaElement;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.TypeExpression;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class ScaffoldingWriter {
    private Deque<ScopeWriter> writers = new ArrayDeque<ScopeWriter>();
    private KeyValuePair lastKeyValuePair;

    public ScaffoldingWriter(Content content) {
        this.writers.push(new ContentScopeWriter(content));
    }

    public void startObject() {
        ObjectScopeWriter objectWriter = new ObjectScopeWriter();
        this.writers.peek().linkParentNode(objectWriter);
        this.writers.push(objectWriter);
    }

    public void startArray() {
        ArrayScopeWriter arrayWriter = new ArrayScopeWriter();
        this.writers.peek().linkParentNode(arrayWriter);
        this.writers.push(arrayWriter);
    }

    public void startKeyValuePair() {
        KeyValuePairScopeWriter keyValuePairWriter = new KeyValuePairScopeWriter(this);
        this.writers.peek().linkParentNode(keyValuePairWriter);
        this.writers.push(keyValuePairWriter);
    }

    public void startAttribute() {
        AttributeScopeWriter attributeWriter = new AttributeScopeWriter(this.lastKeyValuePair);
        this.writers.push(attributeWriter);
    }

    public void startAsExpression(ObjectType objectType) {
        if (this.isClassInformationAvailable(objectType)) {
            AsExpressionWriter objectWriter = new AsExpressionWriter(objectType);
            this.writers.peek().linkParentNode(objectWriter);
            this.writers.push(objectWriter);
        }
    }

    public void writeKey(QName name) {
        this.writers.peek().writeKey(name);
    }

    public void writeValue(MetadataType dataType) {
        this.writers.peek().writeValue(dataType);
    }

    public void endKeyValuePair() {
        this.writers.pop();
    }

    public void endAttribute() {
        this.writers.pop();
    }

    public void endArray() {
        this.writers.peek().get();
        this.writers.pop();
    }

    public void endObject() {
        this.fixObjectIfEmpty();
        this.writers.pop();
    }

    private void fixObjectIfEmpty() {
        ObjectElements objectElements;
        MultipleKeyValuePairObj multipleKeyValuePairObject;
        ObjectPattern pattern;
        EObject eObject = this.writers.peek().get();
        if (eObject instanceof MultipleKeyValuePairObj && (pattern = (multipleKeyValuePairObject = (MultipleKeyValuePairObj)eObject).getPattern()) instanceof ObjectElements && (objectElements = (ObjectElements)pattern).getObjectElements().isEmpty()) {
            multipleKeyValuePairObject.setPattern(null);
        }
    }

    public void endAsExpression(ObjectType objectType) {
        if (this.isClassInformationAvailable(objectType)) {
            this.writers.pop();
        }
    }

    private boolean isClassInformationAvailable(ObjectType objectType) {
        return MetadataFormat.JAVA.equals((Object)objectType.getMetadataFormat()) && objectType.getAnnotation(ClassInformationAnnotation.class).isPresent();
    }

    private static Expression writeLiteral(MetadataType dataType) {
        if (dataType instanceof BooleanType) {
            BooleanLiteral literal = DFLFactory.eINSTANCE.createBooleanLiteral();
            literal.setValue(true);
            return literal;
        }
        if (dataType instanceof DateType) {
            AnyDateLiteral date = DFLFactory.eINSTANCE.createAnyDateLiteral();
            date.setValue("|2003-10-01|");
            return date;
        }
        if (dataType instanceof DateTimeType) {
            AnyDateLiteral dateTime = DFLFactory.eINSTANCE.createAnyDateLiteral();
            dateTime.setValue("|2003-10-01T23:57:59Z|");
            return dateTime;
        }
        if (dataType instanceof NumberType) {
            RealLiteral real = DFLFactory.eINSTANCE.createRealLiteral();
            real.setValue(new BigDecimal(2));
            return real;
        }
        if (dataType instanceof StringType) {
            Object value = "\"????\"";
            Optional enumAnnotation = dataType.getAnnotation(EnumAnnotation.class);
            if (enumAnnotation.isPresent() && ((EnumAnnotation)enumAnnotation.get()).getValues() != null && ((EnumAnnotation)enumAnnotation.get()).getValues().length > 0) {
                value = "\"" + ((EnumAnnotation)enumAnnotation.get()).getValues()[0].toString() + "\"";
            }
            QuotedStringLiteral string = DFLFactory.eINSTANCE.createQuotedStringLiteral();
            string.setValue((String)value);
            return string;
        }
        NullLiteral nullLiteral = DFLFactory.eINSTANCE.createNullLiteral();
        nullLiteral.setValue("null");
        return nullLiteral;
    }

    private static final class ArrayScopeWriter
    extends ScopeWriter {
        private DflFactoryUtils.ArrayWrapper array = DflFactoryUtils.createArray();

        @Override
        public void linkParentNode(ScopeWriter writer) {
            this.array.add((ArrayElement)((Expression)writer.get()));
        }

        @Override
        public void writeValue(MetadataType dataType) {
            this.array.add((ArrayElement)ScaffoldingWriter.writeLiteral(dataType));
        }

        @Override
        public EObject get() {
            return this.array.get();
        }
    }

    private static final class AsExpressionWriter
    extends ScopeWriter {
        private As asExpression;

        public AsExpressionWriter(ObjectType structuredModel) {
            String className = ((ClassInformationAnnotation)structuredModel.getAnnotation(ClassInformationAnnotation.class).get()).getClassname();
            this.asExpression = DFLFactory.eINSTANCE.createAs();
            TypeExpression type = DFLFactory.eINSTANCE.createTypeExpression();
            TypeReference simpleType = DFLFactory.eINSTANCE.createTypeReference();
            Schema schema = DFLFactory.eINSTANCE.createSchema();
            SchemaElement schemaElement = DFLFactory.eINSTANCE.createSchemaElement();
            QuotedStringLiteral quotedClazzName = DFLFactory.eINSTANCE.createQuotedStringLiteral();
            quotedClazzName.setValue("\"" + className + "\"");
            schemaElement.setName("class");
            schemaElement.setValue((Expression)quotedClazzName);
            schema.getElements().add((Object)schemaElement);
            simpleType.setFullQualifiedName("Object");
            simpleType.setSchema(schema);
            IntersectionTypeExpression intersectionType = DFLFactory.eINSTANCE.createIntersectionTypeExpression();
            intersectionType.getTypes().add((Object)simpleType);
            type.getTypes().add((Object)intersectionType);
            this.asExpression.setType(type);
        }

        @Override
        public void linkParentNode(ScopeWriter writer) {
            this.asExpression.setElement((Expression)writer.get());
        }

        @Override
        public EObject get() {
            return this.asExpression;
        }
    }

    private static final class AttributeScopeWriter
    extends ScopeWriter {
        private Attribute attribute;

        public AttributeScopeWriter(KeyValuePair keyValuePair) {
            Key key = keyValuePair.getKey();
            Attributes attributes = key.getAttributes() != null ? key.getAttributes() : DFLFactory.eINSTANCE.createAttributes();
            this.attribute = DFLFactory.eINSTANCE.createAttribute();
            attributes.getAttributes().add((Object)this.attribute);
            key.setAttributes(attributes);
        }

        @Override
        public void linkParentNode(ScopeWriter writer) {
        }

        @Override
        public void writeKey(QName qName) {
            this.attribute.setName(ScaffoldingHelper.adjustWithQuotes(qName.getLocalPart()));
            DFLModelHelper.assignNamespace((Attribute)this.attribute, (QName)qName);
        }

        @Override
        public void writeValue(MetadataType dataType) {
            this.attribute.setValue(ScaffoldingWriter.writeLiteral(dataType));
        }

        @Override
        public EObject get() {
            return this.attribute;
        }
    }

    private static final class ContentScopeWriter
    extends ScopeWriter {
        private Content content;

        public ContentScopeWriter(Content content) {
            this.content = content;
        }

        @Override
        public void linkParentNode(ScopeWriter writer) {
            EObject eObject = writer.get();
            if (eObject instanceof Expression) {
                this.content.setElement((Expression)eObject);
            }
        }

        @Override
        public void writeValue(MetadataType dataType) {
            this.content.setElement(ScaffoldingWriter.writeLiteral(dataType));
        }

        @Override
        public EObject get() {
            return this.content;
        }
    }

    private static final class KeyValuePairScopeWriter
    extends ScopeWriter {
        private KeyValuePair keyValuePair;

        public KeyValuePairScopeWriter(ScaffoldingWriter writer) {
            writer.lastKeyValuePair = this.keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
        }

        @Override
        public void linkParentNode(ScopeWriter writer) {
            this.keyValuePair.setValue((Expression)writer.get());
        }

        @Override
        public void writeKey(QName qName) {
            Key key = DFLFactory.eINSTANCE.createKey();
            StringLiteral keyName = DFLFactory.eINSTANCE.createStringLiteral();
            String localPart = ScaffoldingHelper.adjustWithQuotes(qName.getLocalPart());
            keyName.setValue(localPart);
            DFLModelHelper.assignNamespace((Key)key, (QName)qName);
            key.setValue((KeyExpression)keyName);
            this.keyValuePair.setKey(key);
        }

        @Override
        public void writeValue(MetadataType dataType) {
            this.keyValuePair.setValue(ScaffoldingWriter.writeLiteral(dataType));
        }

        @Override
        public EObject get() {
            return this.keyValuePair;
        }
    }

    private static final class ObjectScopeWriter
    extends ScopeWriter {
        private MultipleKeyValuePairObj object = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
        private ObjectElements objectElements = DFLFactory.eINSTANCE.createObjectElements();

        public ObjectScopeWriter() {
            this.object.setPattern((ObjectPattern)this.objectElements);
        }

        @Override
        public void linkParentNode(ScopeWriter writer) {
            this.objectElements.getObjectElements().add((Object)((ObjectElement)writer.get()));
        }

        @Override
        public EObject get() {
            return this.object;
        }
    }

    private static abstract class ScopeWriter {
        private ScopeWriter() {
        }

        public abstract EObject get();

        public void linkParentNode(ScopeWriter writer) {
        }

        public void writeKey(QName qName) {
        }

        public void writeValue(MetadataType dataType) {
        }
    }
}

