/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.scafflod;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.DoBlock;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.HeaderSeparator;
import org.mule.tooling.dfl.dFL.ImportDirective;
import org.mule.tooling.dfl.dFL.InputDirective;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.LiteralValue;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.OptionElement;
import org.mule.tooling.dfl.dFL.Options;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.dFL.VersionDirective;
import org.mule.tooling.dfl.ui.contentassist.operators.DFLOperatorFactory;
import org.mule.tooling.dfl.ui.internal.DflActivator;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.dfl.util.DFLModelHelper;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.utils.SilentRunner;

public class ScaffoldingHelper {
    private static List<String> KEYWORDS = DFLOperatorFactory.getOperatorsName();

    public static OptionElement addOption(OutputDirective output, String name, Object value) {
        if (output.getOptions() == null) {
            output.setOptions(DFLFactory.eINSTANCE.createOptions());
        }
        OptionElement createOptionElement = DFLFactory.eINSTANCE.createOptionElement();
        output.getOptions().getOptions().add((Object)createOptionElement);
        createOptionElement.setName(name);
        LiteralValue literalValue = ScaffoldingHelper.toLiteralExpression(value);
        createOptionElement.setValue(literalValue);
        return createOptionElement;
    }

    public static LiteralValue toLiteralExpression(Object value) {
        if (value instanceof String) {
            QuotedStringLiteral stringLiteral = DFLFactory.eINSTANCE.createQuotedStringLiteral();
            stringLiteral.setValue("\"" + (String)value + "\"");
            return stringLiteral;
        }
        if (value instanceof Boolean) {
            BooleanLiteral booleanLiteral = DFLFactory.eINSTANCE.createBooleanLiteral();
            booleanLiteral.setValue(((Boolean)value).booleanValue());
            return booleanLiteral;
        }
        if (value instanceof Integer || value instanceof Long) {
            IntegerLiteral integer = DFLFactory.eINSTANCE.createIntegerLiteral();
            integer.setValue(BigDecimal.valueOf((Long)value));
            return integer;
        }
        if (value instanceof BigDecimal) {
            IntegerLiteral integer = DFLFactory.eINSTANCE.createIntegerLiteral();
            integer.setValue((BigDecimal)value);
            return integer;
        }
        throw new InvalidParameterException("Value " + String.valueOf(value) + " is not supported as literal");
    }

    public static String toString(Document scaffoldNew) {
        Content content = scaffoldNew.getBody().getContent();
        if (content.getElement() == null) {
            return "";
        }
        return ScaffoldingHelper.eObjectToString((EObject)scaffoldNew);
    }

    public static String eObjectToString(EObject scaffoldNew) {
        String string;
        block8: {
            Resource resource = null;
            try {
                Injector injector = DflActivator.getInstance().getInjector("org.mule.tooling.dfl.DFL");
                ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
                if (scaffoldNew.eResource() == null) {
                    XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
                    URI fileURI = URI.createFileURI((String)"scaffold.dwl");
                    resource = resourceSet.createResource(fileURI);
                    resource.getContents().clear();
                    resource.getContents().add((Object)scaffoldNew);
                }
                string = serializer.serialize(scaffoldNew);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                if (resource != null) {
                    try {
                        resource.delete(null);
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                resource.delete(null);
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static Optional<Expression> fromString(String scaffoldNew, IProject project) {
        Injector injector = DflActivator.getInstance().getInjector("org.mule.tooling.dfl.DFL");
        XtextResourceSet resourceSet = (XtextResourceSet)((XtextResourceSetProvider)injector.getInstance(XtextResourceSetProvider.class)).get(project);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = resourceSet.createResource(URI.createFileURI((String)"scaffold.dwl"));
        SilentRunner.run(() -> resource.load((InputStream)new ByteArrayInputStream(scaffoldNew.getBytes(IMuleResources.DEFAULT_CHARSET)), null));
        if (!resource.getContents().isEmpty()) {
            return Optional.of(((Document)resource.getContents().get(0)).getBody().getContent().getElement());
        }
        return Optional.empty();
    }

    public static Document buildDocument() {
        Document document = DFLFactory.eINSTANCE.createDocument();
        Body buildBody = ScaffoldingHelper.buildBody(document);
        ScaffoldingHelper.buildVersionDirective(ScaffoldingHelper.buildHeader(buildBody));
        ScaffoldingHelper.buildContent(buildBody);
        return document;
    }

    public static Document buildEmptyDocument(MetadataType payloadType) {
        Document document = ScaffoldingHelper.buildDocument();
        Body buildBody = ScaffoldingHelper.buildBody(document);
        Content content = ScaffoldingHelper.buildContent(buildBody);
        MultipleKeyValuePairObj object = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
        content.setElement((Expression)object);
        ScaffoldingHelper.buildOutputDirective(ScaffoldingHelper.buildHeader(buildBody), WeaveUIModuleManager.getModuleByMetaDataModel(payloadType));
        return document;
    }

    public static boolean isEmptyDocument(Document document) {
        MultipleKeyValuePairObj object;
        ObjectPattern pattern;
        EObject eObject;
        Optional content = DFLModelHelper.getBodyContentExpression((Document)document);
        if (content.isPresent() && (eObject = (EObject)content.get()) instanceof MultipleKeyValuePairObj && (pattern = (object = (MultipleKeyValuePairObj)eObject).getPattern()) instanceof ObjectElements) {
            return ((ObjectElements)pattern).getObjectElements().isEmpty();
        }
        return false;
    }

    public static Body buildBody(Document document) {
        Body body = document.getBody();
        if (body == null) {
            body = DFLFactory.eINSTANCE.createBody();
            document.setBody(body);
        }
        return body;
    }

    public static Header buildHeader(Body body) {
        Header header = body.getHeader();
        if (header == null) {
            header = DFLFactory.eINSTANCE.createHeader();
            body.setHeader(header);
            HeaderSeparator headerSeparator = DFLFactory.eINSTANCE.createHeaderSeparator();
            headerSeparator.setSeparator("---");
            body.setSeparator(headerSeparator);
        }
        return header;
    }

    public static void addDirective(Document document, Directive directive) {
        Body body = ScaffoldingHelper.buildBody(document);
        Header header = ScaffoldingHelper.buildHeader(body);
        header.getDirectives().add((Object)directive);
        ScaffoldingHelper.buildHeaderSeparator(body);
    }

    public static OutputDirective buildOutputDirective(Header header, IWeaveUIModule metadataType) {
        return ScaffoldingHelper.buildOutputDirective(header, metadataType.getMimeTypes().get(0));
    }

    public static OutputDirective buildOutputDirective(Header header, String mimetype) {
        OutputDirective outputDirective = ScaffoldingHelper.findOutputDirective(header);
        outputDirective.setMimeType(mimetype);
        if (!header.getDirectives().contains((Object)outputDirective)) {
            header.getDirectives().add((Object)outputDirective);
        }
        return outputDirective;
    }

    public static InputDirective buildInputDirective(Header header, String name, IWeaveUIModule metadataType) {
        InputDirective result = DFLFactory.eINSTANCE.createInputDirective();
        result.setName(name);
        result.setMimeType(metadataType.getMimeTypes().get(0));
        header.getDirectives().add((Object)result);
        return result;
    }

    public static VersionDirective buildVersionDirective(Header header) {
        VersionDirective result = DFLFactory.eINSTANCE.createVersionDirective();
        result.setVersion("%dw 2.0");
        header.getDirectives().add((Object)result);
        return result;
    }

    public static NamespaceDirective buildNamespaceDirective(Document document, Header header, String prefix, String value) {
        Optional namespace = DFLModelHelper.getNamespaceDeclarationByUri((Document)document, (String)value);
        if (namespace.isPresent()) {
            return (NamespaceDirective)namespace.get();
        }
        NamespaceDirective result = DFLFactory.eINSTANCE.createNamespaceDirective();
        result.setName(prefix);
        result.setValue(value);
        header.getDirectives().add((Object)result);
        return result;
    }

    public static NamespaceDirective buildNamespaceDirective(Document document, String value) {
        Optional namespace = DFLModelHelper.getNamespaceDeclarationByUri((Document)document, (String)value);
        if (namespace.isPresent()) {
            return (NamespaceDirective)namespace.get();
        }
        NamespaceDirective result = DFLFactory.eINSTANCE.createNamespaceDirective();
        int index = 0;
        while (DFLModelHelper.getNamespaceDeclarationByPrefix((Document)document, (String)("ns" + index)).isPresent()) {
            ++index;
        }
        result.setName("ns" + index);
        result.setValue(value);
        ScaffoldingHelper.buildHeader(ScaffoldingHelper.buildBody(document)).getDirectives().add((Object)result);
        return result;
    }

    public static VariableDirective buildConstDirective(Header header, String name, String value) {
        VariableDirective result = DFLFactory.eINSTANCE.createVariableDirective();
        result.setName(name);
        QuotedStringLiteral constValue = DFLFactory.eINSTANCE.createQuotedStringLiteral();
        constValue.setValue("\"" + value + "\"");
        result.setExpression((Expression)constValue);
        header.getDirectives().add((Object)result);
        return result;
    }

    public static void buildHeaderSeparator(Body body) {
        HeaderSeparator separator = body.getSeparator();
        if (separator == null) {
            separator = DFLFactory.eINSTANCE.createHeaderSeparator();
            separator.setSeparator("---");
            body.setSeparator(separator);
        }
    }

    public static Content buildContent(Body body) {
        Content content = body.getContent();
        if (content == null) {
            content = DFLFactory.eINSTANCE.createContent();
            body.setContent(content);
        }
        return content;
    }

    public static Content buildContent(Content content) {
        return content;
    }

    public static QName defineNamespace(Document document, QName qName) {
        if (StringUtils.isNotEmpty((String)qName.getNamespaceURI())) {
            String localPart = qName.getLocalPart();
            String prefix = StringUtils.isEmpty((String)qName.getPrefix()) ? "ns0" : qName.getPrefix();
            String namespaceUri = qName.getNamespaceURI();
            Optional namespaceDeclaration = DFLModelHelper.getNamespaceDeclarationByUri((Document)document, (String)namespaceUri);
            if (namespaceDeclaration.isPresent()) {
                prefix = ((NamespaceDirective)namespaceDeclaration.get()).getName();
            } else {
                namespaceDeclaration = DFLModelHelper.getNamespaceDeclarationByPrefix((Document)document, (String)prefix);
                if (namespaceDeclaration.isPresent() && !((NamespaceDirective)namespaceDeclaration.get()).getValue().equals(namespaceUri)) {
                    List namespaceDirectives = DFLModelHelper.getNamespaceDirectives((Document)document);
                    ArrayList existingNames = Lists.newArrayList();
                    for (NamespaceDirective namespaceDirective : namespaceDirectives) {
                        existingNames.add(namespaceDirective.getName());
                    }
                    prefix = DFLModelHelper.verifyName((List)existingNames, (String)prefix);
                }
            }
            ScaffoldingHelper.buildNamespaceDirective(document, ScaffoldingHelper.buildHeader(ScaffoldingHelper.buildBody(document)), prefix, namespaceUri);
            qName = new QName(namespaceUri, localPart, prefix);
        }
        return qName;
    }

    public static String insertHeaderComment(String content, String comment) {
        int headerSeparatorLocation = content.indexOf("---");
        StringBuilder scriptBuilder = new StringBuilder(content);
        scriptBuilder.insert(headerSeparatorLocation + "---".length(), comment);
        return scriptBuilder.toString();
    }

    public static String adjustWithQuotes(String str) {
        if (DFLModelHelper.requiresQuotes((String)str)) {
            return "'" + str.replace("\"", "\\\"") + "'";
        }
        return str;
    }

    public static boolean requiresQuotes(String str) {
        String requireQuotes = "`~!$%^&*()+=[]\\{}|;:,./<>? \"#";
        return StringUtils.containsAny((String)str, (char[])requireQuotes.toCharArray()) || StringUtils.isNumeric((String)str) || str.startsWith("-") || str.startsWith("_") || ScaffoldingHelper.isKeyword(str);
    }

    private static boolean isKeyword(String str) {
        return KEYWORDS.contains(str);
    }

    public static String toCanonicalPath(GraphicalTreeNode<?> node) {
        if (node != null) {
            boolean hasParent = node.getParent() != null;
            return hasParent ? ScaffoldingHelper.toCanonicalPath(node.getParent()) + "." + String.valueOf(MetadataTypeHelper.toQName((ObjectFieldType)((ObjectFieldType)node.getModel()))) : ScaffoldingHelper.toQName(node).toString();
        }
        return "";
    }

    private static OutputDirective findOutputDirective(Header header) {
        OutputDirective outputDirective = null;
        EList directives = header.getDirectives();
        for (Directive directive : directives) {
            if (!(directive instanceof OutputDirective)) continue;
            outputDirective = (OutputDirective)directive;
        }
        return outputDirective != null ? outputDirective : DFLFactory.eINSTANCE.createOutputDirective();
    }

    private static QName toQName(GraphicalTreeNode<?> node) {
        QName qName = new QName(node.getId() != null ? node.getId() : node.getLabel());
        Object metadataType = node.getModel();
        if (metadataType instanceof ObjectType && MetadataFormat.XML.equals((Object)((ObjectType)metadataType).getMetadataFormat()) && ((ObjectType)metadataType).getFields().size() == 1) {
            ObjectType objectType = (ObjectType)metadataType;
            qName = ((ObjectFieldType)objectType.getFields().iterator().next()).getKey().getName();
        }
        return qName;
    }

    public static Object fromLiteralExpression(LiteralValue literalValue) {
        if (literalValue instanceof QuotedStringLiteral) {
            return ((QuotedStringLiteral)literalValue).getValue().replace("\"", "");
        }
        if (literalValue instanceof BooleanLiteral) {
            return ((BooleanLiteral)literalValue).isValue();
        }
        if (literalValue instanceof IntegerLiteral) {
            return ((IntegerLiteral)literalValue).getValue();
        }
        throw new InvalidParameterException("LiteralValue not supported");
    }

    public static void addOptions(OutputDirective outputDirective, Map<String, Object> valuesForOptions) {
        Options options = DFLFactory.eINSTANCE.createOptions();
        for (Map.Entry<String, Object> option : valuesForOptions.entrySet()) {
            options.getOptions().add((Object)ScaffoldingHelper.createOption(option));
        }
        outputDirective.setOptions(valuesForOptions.isEmpty() ? null : options);
    }

    public static OptionElement createOption(Map.Entry<String, Object> option) {
        OptionElement optionElement = DFLFactory.eINSTANCE.createOptionElement();
        optionElement.setName(option.getKey());
        optionElement.setValue(ScaffoldingHelper.toLiteralExpression(option.getValue()));
        return optionElement;
    }

    public static String toExpressionAssignmentString(Document document, Expression value) {
        Expression assignment = value;
        StringBuilder stringBuilder = new StringBuilder();
        List importDirectives = DFLModelHelper.getImportDirectives((Document)document);
        if (importDirectives != null && !importDirectives.isEmpty()) {
            for (ImportDirective importDirective : importDirectives) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(ScaffoldingHelper.eObjectToString((EObject)importDirective).trim());
            }
        }
        if (assignment instanceof DoBlock) {
            Body doBlockBody = ((DoBlock)assignment).getBody();
            EList directives = doBlockBody.getHeader().getDirectives();
            for (Directive directive : directives) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(ScaffoldingHelper.eObjectToString((EObject)directive).trim());
            }
            assignment = doBlockBody.getContent().getElement();
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append("---").append("\n");
        }
        stringBuilder.append(ScaffoldingHelper.eObjectToString((EObject)assignment).trim());
        return stringBuilder.toString();
    }
}

