/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.scafflod;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.dfl.ui.output.ScaffoldingChildrenProvider;
import org.mule.tooling.dfl.ui.scafflod.MetadataTypeDecorator;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingFieldSelectionUI;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;
import org.mule.tooling.ui.widgets.tree.ITreeSelectionValidation;
import org.mule.tooling.ui.widgets.tree.NotEmptyTreeValidation;
import org.mule.tooling.ui.widgets.tree.SelectAllFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public class ScaffoldingFieldSelectionPresenter
implements IDialogEditorPresenter<ScaffoldingFieldSelectionUI> {
    private ScaffoldingFieldSelectionUI editor;
    private MetadataType output;
    private IEditorMessageLogger logger;
    private List<MetadataType> fields = new ArrayList<MetadataType>();

    public ScaffoldingFieldSelectionPresenter(MetadataType metadataType) {
        this.output = metadataType;
    }

    public void handle(ScaffoldingFieldSelectionUI editor) {
        this.editor = editor;
        SelectAllFilteredTree<GraphicalTreeNode<?>> treeViewer = editor.getTreeViewer();
        treeViewer.getViewer().setLabelProvider((IBaseLabelProvider)new GraphicalTreeLabelProvider());
        treeViewer.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        ScaffoldingChildrenProvider rootChildrenProvider = new ScaffoldingChildrenProvider(this.output);
        WeaveGraphicalTreeNode<MetadataType> rootNode = new WeaveGraphicalTreeNode<MetadataType>("Output", "Expected Output", this.output, rootChildrenProvider);
        treeViewer.setInput(rootNode);
        treeViewer.addSelectionValidation((ITreeSelectionValidation)new NotEmptyTreeValidation(treeViewer, "Output", this.logger));
        treeViewer.getViewer().expandToLevel(2);
    }

    public List<MetadataType> getFields() {
        return this.fields;
    }

    public void onSave() {
        Object[] checkedElements = this.editor.getTreeViewer().getCheckedElements();
        boolean shouldRemoveRoot = this.checkRootElement(this.output);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicalTreeNode node;
            Object model;
            Object object = objectArray[n2];
            if (object instanceof GraphicalTreeNode && (model = (node = (GraphicalTreeNode)object).getModel()) instanceof ObjectFieldType) {
                String canonicalPath = ScaffoldingHelper.toCanonicalPath(node);
                MetadataTypeDecorator fieldWithPath = new MetadataTypeDecorator((MetadataType)model, this.removeRoot(canonicalPath, shouldRemoveRoot));
                this.fields.add(fieldWithPath);
            }
            ++n2;
        }
    }

    public void onCancel() {
    }

    public void setMessageLogger(IEditorMessageLogger logger) {
        this.logger = logger;
    }

    private boolean checkRootElement(MetadataType metadataType) {
        boolean shouldRemoveRoot = false;
        if (MetadataFormat.JSON.equals((Object)metadataType.getMetadataFormat())) {
            shouldRemoveRoot = true;
        } else if (MetadataFormat.CSV.equals((Object)metadataType.getMetadataFormat())) {
            shouldRemoveRoot = true;
        } else if (metadataType instanceof ObjectType || MetadataFormat.JAVA.equals((Object)metadataType.getMetadataFormat())) {
            shouldRemoveRoot = true;
        } else if (metadataType instanceof ArrayType) {
            shouldRemoveRoot = this.checkRootElement(((ArrayType)metadataType).getType());
        }
        return shouldRemoveRoot;
    }

    private String removeRoot(String canonicalPath, boolean shouldRemoveRoot) {
        return shouldRemoveRoot ? canonicalPath.substring(canonicalPath.indexOf(".") + 1) : canonicalPath;
    }

    public void validate() {
    }
}

