/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.quickfix;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.dfl.ui.embedded.editor.DataWeaveIssue;
import org.mule.tooling.dfl.ui.quickfix.WeaveTextDocumentEclipseAdaptor;
import org.mule.weave.v2.editor.QuickFix;
import org.mule.weave.v2.editor.QuickFixAction;
import org.mule.weave.v2.editor.WeaveTextDocument;

public class DFLQuickfixProvider
extends DefaultQuickfixProvider {
    public boolean hasResolutionFor(String issueCode) {
        return true;
    }

    public List<IssueResolution> getResolutions(final Issue issue) {
        if (issue instanceof DataWeaveIssue) {
            QuickFix[] quickFixs = ((DataWeaveIssue)issue).getQuickFix();
            Function<QuickFix, IssueResolution> _function = new Function<QuickFix, IssueResolution>(){

                @Override
                public IssueResolution apply(final QuickFix theFix) {
                    IModificationContext createModificationContext = DFLQuickfixProvider.this.getModificationContextFactory().createModificationContext(issue);
                    String _name = theFix.name();
                    String _description = theFix.description();
                    IModification _function = new IModification(){

                        public void apply(IModificationContext context) throws Exception {
                            QuickFixAction _quickFix = theFix.quickFix();
                            XtextDocument _document = ((DataWeaveIssue)issue).getDocument();
                            WeaveTextDocumentEclipseAdaptor _weaveTextDocumentEclipseAdaptor = new WeaveTextDocumentEclipseAdaptor((IDocument)_document);
                            _quickFix.run((WeaveTextDocument)_weaveTextDocumentEclipseAdaptor);
                        }
                    };
                    return new IssueResolution(_name, _description, null, createModificationContext, _function);
                }
            };
            return Stream.of(quickFixs).map(_function).collect(Collectors.toList());
        }
        return super.getResolutions(issue);
    }
}

