/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.preview.json;

import java.util.LinkedList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.mule.tooling.dfl.ui.preview.json.JsonColorProvider;

public class JsonScanner
extends RuleBasedScanner {
    public JsonScanner() {
        this.initScanner();
    }

    private void initScanner() {
        Token string = new Token((Object)new TextAttribute(JsonColorProvider.getColor(JsonColorProvider.STRING)));
        Token value = new Token((Object)new TextAttribute(JsonColorProvider.getColor(JsonColorProvider.VALUE)));
        Token defaultText = new Token((Object)new TextAttribute(JsonColorProvider.getColor(JsonColorProvider.DEFAULT)));
        Token nullValue = new Token((Object)new TextAttribute(JsonColorProvider.getColor(JsonColorProvider.NULL)));
        LinkedList<Object> rules = new LinkedList<Object>();
        rules.add(new MultiLineRule(":\"", "\"", (IToken)value, '\\'));
        rules.add(new MultiLineRule("\"", "\"", (IToken)string, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JsonWordDetector(), (IToken)defaultText);
        wordRule.addWord("null", (IToken)nullValue);
        rules.add(wordRule);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JsonWhitespaceDetector()));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private static final class JsonWhitespaceDetector
    implements IWhitespaceDetector {
        private JsonWhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }

    private static final class JsonWordDetector
    implements IWordDetector {
        private JsonWordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierPart(character);
        }
    }
}

