/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.preview.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class JsonColorProvider {
    public static final RGB STRING = ThemeUtils.getCurrentTheme().getDFLStringColor();
    public static final RGB DEFAULT = ThemeUtils.getCurrentTheme().getDFLTypeColor();
    public static final RGB VALUE = ThemeUtils.getCurrentTheme().getDFLNumberColor();
    public static final RGB NULL = ThemeUtils.getCurrentTheme().getDFLKeywordColor();
    protected static Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    public void dispose() {
        Iterator<Color> e = fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public static Color getColor(RGB rgb) {
        Color color = fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            fColorTable.put(rgb, color);
        }
        return color;
    }
}

