/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.output;

import java.util.Arrays;
import java.util.List;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.dfl.ui.output.JavaRecursionField;
import org.mule.tooling.dfl.ui.output.MetaDataModelSafeRecursionChildrenProvider;
import org.mule.tooling.dfl.ui.output.SafeRecursionImpl;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class ScaffoldingChildrenProvider
implements IGraphicalChildrenProvider<MetadataType> {
    private MetadataType outputMetadata;

    public ScaffoldingChildrenProvider(MetadataType output) {
        this.outputMetadata = output;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<MetadataType> parent) {
        String rootLabel = MetadataTypeHelper.getLabel((MetadataType)this.outputMetadata);
        SafeRecursionImpl safeRecursion = new SafeRecursionImpl();
        if (MetadataFormat.JAVA.equals((Object)this.outputMetadata.getMetadataFormat()) && this.outputMetadata instanceof ObjectType) {
            safeRecursion = new SafeRecursionImpl();
            MetadataType defaultPojoMetaDataModel = this.outputMetadata;
            String className = defaultPojoMetaDataModel.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getName).orElse("Pojo");
            safeRecursion.push(new JavaRecursionField(className));
        }
        WeaveGraphicalTreeNode<MetadataType> rootNode = new WeaveGraphicalTreeNode<MetadataType>(rootLabel, "Expected Output", this.outputMetadata, new MetaDataModelSafeRecursionChildrenProvider(safeRecursion));
        return Arrays.asList(new GraphicalTreeNode[]{rootNode});
    }
}

