/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.output;

import java.util.ArrayDeque;
import java.util.Deque;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.output.SafeRecursion;
import org.mule.tooling.dfl.ui.output.SafeRecursionField;

public class SafeRecursionImpl
implements SafeRecursion {
    private Deque<SafeRecursionField> fields;

    public SafeRecursionImpl() {
        this.fields = new ArrayDeque<SafeRecursionField>();
    }

    public SafeRecursionImpl(SafeRecursion safeRecursion) {
        this.fields = new ArrayDeque<SafeRecursionField>(safeRecursion.getFields());
    }

    @Override
    public void push(SafeRecursionField recursionField) {
        this.fields.push(recursionField);
    }

    @Override
    public void pop() {
        this.fields.pop();
    }

    @Override
    public boolean checkRecursion(SafeRecursionField recursionField) {
        int hits = 0;
        for (SafeRecursionField field : this.fields) {
            if (!field.equals(recursionField)) continue;
            ++hits;
        }
        return hits < SafeRecursionImpl.getMaxRecursionLevel();
    }

    @Override
    public Deque<SafeRecursionField> getFields() {
        return this.fields;
    }

    private static int getMaxRecursionLevel() {
        return DFLExtendedActivator.getInstance() != null ? DFLExtendedActivator.getInstance().getPreferenceStore().getInt("dataweave.recursivelevel") : 1;
    }
}

