/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.JavaUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModule;
import org.mule.tooling.dfl.ui.viewers.DefaultViewerFactory;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.weave.engine.DataFormatManagerHelper;
import org.mule.weave.v2.module.DataFormat;

public class WeaveUIModuleManager {
    private static final String WEAVE_UI_MODULE_EXTENSION_ID = "org.mule.tooling.dfl.ui.weaveUiModule";
    private static WeaveUIModuleManager instance = new WeaveUIModuleManager();
    private List<WeaveUIModule> modules = new ArrayList<WeaveUIModule>();

    private WeaveUIModuleManager() {
        if (Platform.isRunning()) {
            IConfigurationElement[] configurationElementsFor;
            IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(WEAVE_UI_MODULE_EXTENSION_ID);
            int n = configurationElementsFor.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                SilentRunner.run(() -> {
                    this.modules.add((WeaveUIModule)element.createExecutableExtension("class"));
                    return null;
                }, null);
                ++n2;
            }
        }
    }

    public static IWeaveUIModule getModuleByMetaDataModel(MetadataType payloadType) {
        return WeaveUIModuleManager.getModuleByContentType(WeaveUIModuleManager.getMimeType(payloadType));
    }

    private static String getMimeType(MetadataType payloadType) {
        MetadataFormat resolveMetadataFormat = WeaveUIModuleManager.resolveMetadataFormat(payloadType);
        Iterator iterator = resolveMetadataFormat.getValidMimeTypes().iterator();
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return "application/" + resolveMetadataFormat.getId();
    }

    public static IWeaveUIModule getModuleByContentType(String mimeType) {
        return WeaveUIModuleManager.instance.modules.stream().filter(module -> module.accepts(mimeType)).findAny().orElseGet(() -> {
            Optional dataFormatByMimeType = DataFormatManagerHelper.getDataFormatByMimeType((String)mimeType);
            return dataFormatByMimeType.map(df -> new WeaveUIModule(new DefaultViewerFactory(), (DataFormat<?, ?>)df)).orElse(new JavaUIModule());
        });
    }

    private static MetadataFormat resolveMetadataFormat(MetadataType metadataType) {
        MetadataFormat metadataFormat = metadataType.getMetadataFormat();
        if (metadataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)metadataType;
            return WeaveUIModuleManager.resolveMetadataFormat(arrayType.getType());
        }
        return metadataFormat;
    }

    public static List<String> getMimeTypes() {
        return DataFormatManagerHelper.getMimeTypes();
    }

    public static List<MetadataFormat> getMetadataFormats() {
        return DataFormatManagerHelper.getMetadataFormats();
    }
}

