/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.OptionElement;
import org.mule.tooling.dfl.dFL.Options;
import org.mule.tooling.dfl.ui.module.DataWeaveGraphicalOutputViewer;
import org.mule.tooling.dfl.ui.module.GraphicalAndTextOutputViewer;
import org.mule.tooling.dfl.ui.module.IOutputViewer;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.ui.viewers.IViewerFactory;
import org.mule.tooling.weave.engine.DataFormatManagerHelper;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.parser.module.MimeType;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class WeaveUIModule
implements IWeaveUIModule {
    private IViewerFactory<? extends IDocument> viewerFactory;
    private DataFormat<?, ?> dataFormat;

    public WeaveUIModule(IViewerFactory<? extends IDocument> viewerFactory, DataFormat<?, ?> dataFormat) {
        this.viewerFactory = viewerFactory;
        this.dataFormat = dataFormat;
    }

    @Override
    public List<String> getMimeTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.dataFormat.defaultMimeType().toString());
        Collection asJavaCollection = JavaConversions.asJavaCollection((Iterable)this.dataFormat.acceptedMimeTypes());
        Iterator iterator = asJavaCollection.iterator();
        while (iterator.hasNext()) {
            result.add(((MimeType)iterator.next()).toStringWithoutParameters());
        }
        return result;
    }

    @Override
    public List<String> getExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        Collection fileExtensions = JavaConversions.asJavaCollection((Iterable)this.dataFormat.fileExtensions());
        result.addAll(fileExtensions);
        return result;
    }

    @Override
    public boolean accepts(String mimeType) {
        Optional targetDataFormat = DataFormatManagerHelper.getDataFormatByMimeType((String)mimeType);
        if (!targetDataFormat.isPresent()) {
            return false;
        }
        return this.dataFormat.acceptsMimeType(((DataFormat)targetDataFormat.get()).defaultMimeType());
    }

    @Override
    public List<MetadataFormat> getMetadataFormat() {
        MimeType defaultMimeType = this.dataFormat.defaultMimeType();
        String id = defaultMimeType.subtype().toLowerCase();
        String label = StringUtils.capitalize((String)id);
        MetadataFormat metadataFormat = new MetadataFormat(label, id, this.getMimeTypes().toArray(new String[0]));
        return Arrays.asList(metadataFormat);
    }

    @Override
    public IOutputViewer getOutputPreviewViewer() {
        if (this.isBinaryDataFormat()) {
            return new DataWeaveGraphicalOutputViewer(this);
        }
        return new GraphicalAndTextOutputViewer(this);
    }

    @Override
    public String getSampleDataMimeType() {
        return this.getMimeTypes().get(0);
    }

    @Override
    public String getPreviewResultMimeType() {
        if (this.isBinaryDataFormat()) {
            return "application/dw";
        }
        return this.getMimeTypes().get(0);
    }

    @Override
    public IViewerFactory<? extends IDocument> getInputViewerFactory() {
        return this.viewerFactory;
    }

    @Override
    public Map<String, ModuleOption> getReaderProperties(MetadataType metadataType) {
        List readerOptions = WeaveEngineHelperManager.getReaderOptions((String)this.getMimeTypes().get(0));
        HashMap<String, ModuleOption> properties = new HashMap<String, ModuleOption>();
        for (ModuleOption moduleOption : readerOptions) {
            if (!this.isValidOption(moduleOption, metadataType)) continue;
            properties.put(moduleOption.getName(), moduleOption);
        }
        return properties;
    }

    @Override
    public Map<String, ModuleOption> getWriterProperties(MetadataType metadataType) {
        List readerOptions = WeaveEngineHelperManager.getWriterOptions((String)this.getMimeTypes().get(0));
        HashMap<String, ModuleOption> properties = new HashMap<String, ModuleOption>();
        for (ModuleOption moduleOption : readerOptions) {
            if (!this.isValidOption(moduleOption, metadataType)) continue;
            properties.put(moduleOption.getName(), moduleOption);
        }
        return properties;
    }

    @Override
    public Map<String, Object> getValuesForOptions(MetadataType metadataType, Options options, IMuleProject project) {
        LinkedHashMap<String, Object> newOptions = new LinkedHashMap<String, Object>();
        Map<String, ModuleOption> validProperties = this.getWriterProperties(metadataType);
        if (options != null) {
            EList currentOptions = options.getOptions();
            for (OptionElement optionElement : currentOptions) {
                if (!validProperties.containsKey(optionElement.getName())) continue;
                newOptions.put(optionElement.getName(), ScaffoldingHelper.fromLiteralExpression(optionElement.getValue()));
            }
        }
        return newOptions;
    }

    @Override
    public boolean isBinaryDataFormat() {
        return this.dataFormat.binaryFormat();
    }

    protected boolean isValidOption(ModuleOption moduleOption, MetadataType metadataType) {
        return true;
    }

    protected Optional<Object> getExistingValueForOption(Options options, String optionName) {
        if (options != null) {
            EList currentOptions = options.getOptions();
            for (OptionElement optionElement : currentOptions) {
                if (!optionElement.getName().equals(optionName)) continue;
                return Optional.of(ScaffoldingHelper.fromLiteralExpression(optionElement.getValue()));
            }
        }
        return Optional.empty();
    }
}

