/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.dfl.ui.module.IInputConfigurationViewer;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.weave.engine.ModuleOption;

public class InputConfigurationViewer
implements IInputConfigurationViewer {
    private Map<String, ModuleOption> properties;
    private Map<String, ComponentHolder> components = new HashMap<String, ComponentHolder>();

    public InputConfigurationViewer(Map<String, ModuleOption> properties) {
        this.properties = properties;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        WidgetUtils widgetUtils = new WidgetUtils();
        for (Map.Entry<String, ModuleOption> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String propertyName = WordUtils.capitalize((String)key);
            ModuleOption moduleOption = entry.getValue();
            Object value = moduleOption.getDefaultValue();
            List possibleValues = moduleOption.getPossibleValues();
            if (!possibleValues.isEmpty()) {
                Combo combo = (Combo)widgetUtils.createComponentWithLabel(Combo.class, container, propertyName);
                String[] items = possibleValues.toArray(new String[possibleValues.size()]);
                combo.setItems(items);
                combo.select(0);
                this.components.put(key, new ComboHolder(combo));
                continue;
            }
            if (value instanceof String) {
                Text text = (Text)widgetUtils.createComponentWithLabel(Text.class, container, propertyName);
                text.setText((String)value);
                this.components.put(key, new TextHolder(text));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            Button checkbox = (Button)widgetUtils.createComponentWithLabel(Button.class, container, propertyName, 32);
            checkbox.setSelection(((Boolean)value).booleanValue());
            this.components.put(key, new CheckboxHolder(checkbox));
        }
        return container;
    }

    public void dispose() {
        this.properties.clear();
        this.components.clear();
    }

    @Override
    public void restoreDefaults() {
        for (Map.Entry<String, ComponentHolder> entry : this.components.entrySet()) {
            Object defaultValue = this.properties.get(entry.getKey()).getDefaultValue();
            entry.getValue().setValue(defaultValue);
        }
    }

    @Override
    public void initialize(Map<String, Object> currentValues) {
        for (Map.Entry<String, ComponentHolder> entry : this.components.entrySet()) {
            String key = entry.getKey();
            Object defaultValue = currentValues.get(key);
            defaultValue = defaultValue != null ? defaultValue : this.properties.get(key).getDefaultValue();
            entry.getValue().setValue(defaultValue);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (Map.Entry<String, ModuleOption> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            String value = this.components.get(key).getValue().toString();
            if (entry.getValue().getDefaultValue().equals(this.components.get(key).getValue()) || StringUtils.isEmpty((String)value)) continue;
            configuration.put(key, value);
        }
        return configuration;
    }

    private static final class CheckboxHolder
    implements ComponentHolder {
        private Button checkbox;

        public CheckboxHolder(Button checkbox) {
            this.checkbox = checkbox;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.checkbox.setSelection(Boolean.valueOf((String)value).booleanValue());
            } else if (value instanceof Boolean) {
                this.checkbox.setSelection(Boolean.valueOf((Boolean)value).booleanValue());
            }
        }

        @Override
        public Boolean getValue() {
            return this.checkbox.getSelection();
        }
    }

    private static final class ComboHolder
    implements ComponentHolder {
        private Combo combo;

        public ComboHolder(Combo combo) {
            this.combo = combo;
        }

        @Override
        public void setValue(Object value) {
            this.combo.select(0);
        }

        @Override
        public String getValue() {
            return this.combo.getText();
        }
    }

    private static interface ComponentHolder {
        public void setValue(Object var1);

        public Object getValue();
    }

    private static final class TextHolder
    implements ComponentHolder {
        private Text text;

        public TextHolder(Text text) {
            this.text = text;
        }

        @Override
        public void setValue(Object value) {
            this.text.setText((String)value);
        }

        @Override
        public String getValue() {
            return this.text.getText();
        }
    }
}

