/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.module.DataWeaveGraphicalOutputViewer;
import org.mule.tooling.dfl.ui.module.DataWeaveTextOutputViewer;
import org.mule.tooling.dfl.ui.module.IOutputViewer;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;

public class GraphicalAndTextOutputViewer
implements IOutputViewer {
    private DataWeaveTextOutputViewer text;
    private DataWeaveGraphicalOutputViewer tree;
    private boolean uiFirst;

    public GraphicalAndTextOutputViewer(IWeaveUIModule outputType) {
        this(outputType, false);
    }

    public GraphicalAndTextOutputViewer(IWeaveUIModule outputType, boolean uiFirst) {
        this.uiFirst = uiFirst;
        this.text = new DataWeaveTextOutputViewer(outputType);
        this.tree = new DataWeaveGraphicalOutputViewer(outputType);
    }

    @Override
    public Control createControl(Composite parent) {
        CTabFolder tabs = new CTabFolder(parent, 1024);
        tabs.setBackground(WeaveUIConstants.WHITE);
        tabs.setSelectionBackground(WeaveUIConstants.WHITE);
        GridLayoutFactory.fillDefaults().applyTo((Composite)tabs);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabs);
        CTabItem treeTab = this.createUITab(tabs);
        CTabItem textTab = this.createTextTab(tabs);
        if (this.uiFirst) {
            tabs.setSelection(treeTab);
        } else {
            tabs.setSelection(textTab);
        }
        return tabs;
    }

    private CTabItem createUITab(CTabFolder tabs) {
        CTabItem treeTab = new CTabItem(tabs, 0);
        treeTab.setText("Tree");
        Control createControl = this.tree.createControl((Composite)tabs);
        treeTab.setControl(createControl);
        return treeTab;
    }

    private CTabItem createTextTab(CTabFolder tabs) {
        CTabItem textTab = new CTabItem(tabs, 0);
        textTab.setText("Text");
        Control createControl = this.text.createControl((Composite)tabs);
        textTab.setControl(createControl);
        return textTab;
    }

    @Override
    public void updateInput(String input) {
        this.text.updateInput(input);
        this.tree.updateInput(input);
    }

    public void dispose() {
        this.text.dispose();
        this.tree.dispose();
    }
}

