/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.PatternFilter;
import org.mule.tooling.dfl.ui.graphical.WeaveUIConstants;
import org.mule.tooling.dfl.ui.module.DataWeaveValueGraphicalTreeChildrenProvider;
import org.mule.tooling.dfl.ui.module.DataWeaveValueUIHelper;
import org.mule.tooling.ui.widgets.search.LimitedLevelPatternFilter;
import org.mule.tooling.ui.widgets.tree.StudioFilteredTree;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeContentProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeLabelProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.weave.v2.runtime.DataWeaveValue;

public class DataWeaveValueUITree
extends Composite {
    private StudioFilteredTree tree;
    private CLabel label;
    private StackLayout stackLayout = new StackLayout();

    public DataWeaveValueUITree(Composite parent, int style) {
        super(parent, style);
        this.setBackground(WeaveUIConstants.WHITE);
        GridData layoutData = new GridData(1808);
        layoutData.verticalSpan = 0;
        this.setLayoutData(layoutData);
        this.setLayout((Layout)this.stackLayout);
        this.label = new CLabel((Composite)this, 0);
        this.label.setText("Loading Data ...");
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.label);
        this.tree = new StudioFilteredTree((Composite)this, 66304, (PatternFilter)new LimitedLevelPatternFilter(128));
        this.tree.setInitialText("Loading Data ...");
        this.tree.setBackground(WeaveUIConstants.WHITE);
        this.tree.getViewer().setUseHashlookup(true);
        this.tree.getViewer().getTree().addListener(41, (Listener)new StudioFilteredTree.RowHeightDefinition(20));
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)new DataWeaveValueUITreeLabelProvider());
        this.tree.getViewer().setContentProvider((IContentProvider)new GraphicalTreeContentProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
        this.stackLayout.topControl = this.label;
    }

    public DataWeaveValueUITree content(DataWeaveValue value) {
        this.tree.getViewer().setInput(DataWeaveValueGraphicalTreeChildrenProvider.createRoot(value));
        this.tree.getViewer().expandToLevel(5);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree.getViewer());
        this.stackLayout.topControl = this.tree;
        this.layout();
        return this;
    }

    public StudioFilteredTree getTree() {
        return this.tree;
    }

    private static class DataWeaveValueUITreeLabelProvider
    extends GraphicalTreeLabelProvider {
        private DataWeaveValueUITreeLabelProvider() {
        }

        protected StyledString.Styler getSuffixStyle(GraphicalTreeNode<?> element) {
            if (element != null) {
                DataWeaveValue value = (DataWeaveValue)element.getModel();
                return DataWeaveValueUIHelper.getStyler(value);
            }
            return super.getSuffixStyle(element);
        }
    }
}

