/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.ui.widgets.tree.model.DefaultGraphicalChildrenProvider;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.runtime.ArrayDataWeaveValue;
import org.mule.weave.v2.runtime.DataWeaveNameValue;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ObjectDataWeaveValue;
import org.mule.weave.v2.runtime.SchemaValue;
import org.mule.weave.v2.runtime.SimpleDataWeaveValue;

public class DataWeaveValueGraphicalTreeChildrenProvider
implements IGraphicalChildrenProvider<DataWeaveValue> {
    public static GraphicalTreeNode<DataWeaveValue> createRoot(DataWeaveValue root) {
        GraphicalTreeNode node = new GraphicalTreeNode(root.typeName(), DataWeaveValueGraphicalTreeChildrenProvider.getDescription(root), (Object)root, (IGraphicalChildrenProvider)new DataWeaveValueGraphicalTreeChildrenProvider());
        node.suffix(DataWeaveValueGraphicalTreeChildrenProvider.value(root));
        return new GraphicalTreeNode("Root", "", null, (IGraphicalChildrenProvider)new DefaultGraphicalChildrenProvider(Arrays.asList(node)));
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<DataWeaveValue> parent) {
        DataWeaveNameValue[] attributes;
        GraphicalTreeNode node;
        String description;
        Object label;
        DataWeaveNameValue[] dataWeaveNameValueArray;
        ArrayList children = new ArrayList();
        DataWeaveValue weaveDataModel = (DataWeaveValue)parent.getModel();
        if (weaveDataModel instanceof ArrayDataWeaveValue) {
            DataWeaveValue[] elements = ((ArrayDataWeaveValue)weaveDataModel).elements();
            int i = 0;
            while (i < elements.length) {
                DataWeaveValue dataWeaveValue = elements[i];
                GraphicalTreeNode node2 = new GraphicalTreeNode("[" + i + "] : " + dataWeaveValue.typeName(), DataWeaveValueGraphicalTreeChildrenProvider.getDescription(dataWeaveValue), (Object)dataWeaveValue, (IGraphicalChildrenProvider)this);
                node2.suffix(DataWeaveValueGraphicalTreeChildrenProvider.value(dataWeaveValue));
                children.add(node2);
                ++i;
            }
        } else if (weaveDataModel instanceof ObjectDataWeaveValue) {
            DataWeaveNameValue[] entries = ((ObjectDataWeaveValue)weaveDataModel).entries();
            dataWeaveNameValueArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                DataWeaveNameValue dataWeaveNameValue = dataWeaveNameValueArray[n2];
                label = DataWeaveValueGraphicalTreeChildrenProvider.getLabel(dataWeaveNameValue);
                description = DataWeaveValueGraphicalTreeChildrenProvider.getDescription(dataWeaveNameValue.value());
                node = new GraphicalTreeNode((String)label, description, (Object)dataWeaveNameValue.value(), (IGraphicalChildrenProvider)this);
                node.suffix(DataWeaveValueGraphicalTreeChildrenProvider.value(dataWeaveNameValue.value()));
                children.add(node);
                ++n2;
            }
        }
        dataWeaveNameValueArray = attributes = weaveDataModel.attributes();
        int n = attributes.length;
        int n3 = 0;
        while (n3 < n) {
            DataWeaveNameValue dataWeaveNameValue = dataWeaveNameValueArray[n3];
            label = "@" + DataWeaveValueGraphicalTreeChildrenProvider.getLabel(dataWeaveNameValue);
            description = DataWeaveValueGraphicalTreeChildrenProvider.getDescription(dataWeaveNameValue.value());
            node = new GraphicalTreeNode((String)label, description, (Object)dataWeaveNameValue.value(), (IGraphicalChildrenProvider)this);
            node.suffix(DataWeaveValueGraphicalTreeChildrenProvider.value(dataWeaveNameValue.value()));
            children.add(node);
            ++n3;
        }
        return children;
    }

    private static String value(DataWeaveValue value) {
        if (value instanceof SimpleDataWeaveValue) {
            return ((SimpleDataWeaveValue)value).valueAsString();
        }
        return "";
    }

    private static String getDescription(DataWeaveValue dataWeaveNameValue) {
        SchemaValue[] schemaProperties;
        StringBuilder result = new StringBuilder();
        SchemaValue[] schemaValueArray = schemaProperties = dataWeaveNameValue.schemaProperties();
        int n = schemaProperties.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaValue schemaValue = schemaValueArray[n2];
            result.append("* '").append(schemaValue.name()).append("' : ").append(schemaValue.value()).append("\n");
            ++n2;
        }
        return result.toString();
    }

    private static String getLabel(DataWeaveNameValue dataWeaveNameValue) {
        QName qname = dataWeaveNameValue.name();
        if (qname.ns().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)qname.ns().get()))) {
            return qname.name() + " : " + dataWeaveNameValue.value().typeName();
        }
        return "{" + (String)qname.ns().get() + "}" + qname.name() + " : " + dataWeaveNameValue.value().typeName();
    }
}

