/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.metadata;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.dfl.ui.metadata.RecursiveField;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;

public class RecursionHandler {
    private LinkedHashSet<RecursiveField> fields;
    private Map<MetadataType, Integer> hashes;

    public RecursionHandler() {
        this.fields = Sets.newLinkedHashSet();
        this.hashes = new IdentityHashMap<MetadataType, Integer>();
    }

    public RecursionHandler(RecursionHandler recursionHandler) {
        this.fields = Sets.newLinkedHashSet(recursionHandler.fields);
        this.hashes = new IdentityHashMap<MetadataType, Integer>(recursionHandler.hashes);
    }

    public void add(RecursiveField field) {
        this.fields.add(field);
    }

    public boolean isRecursiveStructured(RecursiveField field) {
        return this.fields.contains(field);
    }

    public void remove(RecursiveField field) {
        this.fields.remove(field);
    }

    public String buildCanonicalPathAt(QName fieldName) {
        StringBuilder sb = new StringBuilder("");
        for (RecursiveField recursiveField : this.fields) {
            sb.append(recursiveField.getName());
            sb.append(".");
        }
        sb.append(fieldName);
        return sb.toString();
    }

    public RecursiveField newField(QName name, MetadataType metadataType) {
        return new RecursiveField(name, MetadataTypeHelper.getLabel((MetadataType)metadataType), metadataType);
    }

    public void store(MetadataType metadataType, int innerHashValue) {
        this.hashes.put(metadataType, innerHashValue);
    }

    public Integer getMetadataTypeHash(MetadataType metadataType) {
        return this.hashes.get(metadataType);
    }
}

