/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.datasense.WeaveTypesConvertersUtils;
import org.mule.tooling.dfl.ui.ls.EclipseSimpleVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.el.tooling.MuleWeaveToolingHelper;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.WeaveResource;
import scala.Option;

public class MuleModuleDefinitionsService
implements IMuleProjectComponent {
    private IMuleProject muleProject;

    public MuleModuleDefinitionsService(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public Optional<WeaveResource> resolveResource(NameIdentifier name) {
        TypeBindings globalBindings = this.getGlobalBindings();
        Optional module = globalBindings.lookupModule(name.name());
        return module.map(mod -> MuleWeaveToolingHelper.toWeaveResource((NameIdentifier)name, (ModuleDefinition)mod));
    }

    public TypeBindings getGlobalBindings() {
        Map<String, MetadataType> functionBindings = DataSenseHolder.getFunctionBindings(this.muleProject);
        TypeBindings globalBindings = WeaveTypesConvertersUtils.fromMap(functionBindings);
        return globalBindings;
    }

    public List<VirtualFile> listFiles() {
        return this.getGlobalBindings().modules().stream().map(module -> this.asVirtualFile((ModuleDefinition)module)).collect(Collectors.toList());
    }

    public EclipseSimpleVirtualFile asVirtualFile(ModuleDefinition module) {
        NameIdentifier name = NameIdentifier.apply((String)module.getName().toString(), (Option)Option.empty());
        String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
        String content = MuleWeaveToolingHelper.toWeaveResource((NameIdentifier)name, (ModuleDefinition)module).content();
        return new EclipseSimpleVirtualFile(weaveFilePath, content, EclipseVirtualFileSystem.getInstance(this.muleProject), name);
    }

    public static MuleModuleDefinitionsService getInstance(IMuleProject muleProject) {
        return (MuleModuleDefinitionsService)muleProject.getProjectComponent(MuleModuleDefinitionsService.class);
    }

    public Optional<VirtualFile> resolveVirtualFile(String path) {
        TypeBindings globalBindings = this.getGlobalBindings();
        Optional module = globalBindings.lookupModule(NameIdentifierHelper.fromWeaveFilePath((String)path, (String)"/").name());
        return module.map(this::asVirtualFile);
    }
}

