/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.utils.SilentRunner;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Option;

public class JavaModuleResourceResolver
implements WeaveResourceResolver {
    static HashMap<String, String> types = new HashMap();
    private IJavaProject project;

    static {
        types.put(List.class.getName(), "Array");
        types.put(List.class.getSimpleName(), "Array");
        types.put(ArrayList.class.getName(), "Array");
        types.put(ArrayList.class.getSimpleName(), "Array");
        types.put(Set.class.getName(), "Array");
        types.put(Set.class.getSimpleName(), "Array");
        types.put(Iterator.class.getName(), "Array");
        types.put(Iterator.class.getSimpleName(), "Array");
        types.put(Iterable.class.getName(), "Array");
        types.put(Iterable.class.getSimpleName(), "Array");
        types.put(String.class.getName(), "String");
        types.put(String.class.getSimpleName(), "String");
        types.put(StringBuilder.class.getName(), "String");
        types.put(StringBuilder.class.getSimpleName(), "String");
        types.put("C", "String");
        types.put("B", "String");
        types.put(Class.class.getName(), "String");
        types.put(CharSequence.class.getName(), "String");
        types.put(CharSequence.class.getSimpleName(), "String");
        types.put(Boolean.class.getName(), "Boolean");
        types.put(Boolean.class.getSimpleName(), "Boolean");
        types.put("Z", "Boolean");
        types.put("F", "Number");
        types.put("I", "Number");
        types.put("J", "Number");
        types.put("F", "Number");
        types.put("D", "Number");
        types.put("S", "Number");
        types.put(Object.class.getName(), "Any");
        types.put(InputStream.class.getName(), "Binary");
        types.put(InputStream.class.getSimpleName(), "Binary");
    }

    public JavaModuleResourceResolver(IJavaProject project) {
        this.project = project;
    }

    public Option<WeaveResource> resolve(NameIdentifier name) {
        return (Option)SilentRunner.runOrElse(() -> {
            IType findType = this.project.findType(this.toJavaName(name.name()));
            if (findType != null) {
                String content = this.createDefinition(findType);
                DefaultWeaveResource anonymous = WeaveResource.anonymous((String)content);
                return Option.apply((Object)anonymous);
            }
            return Option.empty();
        }, Option::empty);
    }

    private String createDefinition(IType findType) throws JavaModelException {
        IMethod[] methods;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%dw 2.0\n");
        IMethod[] iMethodArray = methods = findType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            boolean isStatic = Flags.isStatic((int)method.getFlags());
            boolean isConstructor = method.isConstructor();
            boolean isPublic = Flags.isPublic((int)method.getFlags());
            boolean isVoid = "V".equals(method.getReturnType());
            if ((isStatic && !isVoid || isConstructor) && isPublic) {
                String methodName = isConstructor ? "new" : method.getElementName();
                stringBuilder.append("fun ").append(methodName).append("(");
                ILocalVariable[] parameters = method.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    ILocalVariable param = parameters[i];
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(param.getElementName());
                    stringBuilder.append(": ");
                    IAnnotation[] annotations = param.getAnnotations();
                    Stream<IAnnotation> filter = Stream.of(annotations).filter(annotation -> {
                        String elementName = annotation.getElementName();
                        return elementName.toLowerCase().endsWith("NotNull") || elementName.toLowerCase().endsWith("NonNull");
                    });
                    boolean notNull = filter.findFirst().isPresent();
                    Object weaveType = this.toWeaveType(param.getTypeSignature());
                    if (!notNull) {
                        weaveType = (String)weaveType + " | Null";
                    }
                    stringBuilder.append((String)weaveType);
                    ++i;
                }
                String returnType = isConstructor ? this.toWeaveType(findType.getFullyQualifiedName()) : this.toWeaveType(method.getReturnType());
                stringBuilder.append("): ").append(returnType).append("= ??? \n\n");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private String toWeaveType(String typeSignature) {
        String weaveType;
        if (typeSignature.startsWith("[")) {
            return "Array";
        }
        String className = typeSignature;
        if (className.startsWith("L")) {
            className = className.substring(1);
        }
        if (className.endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        if (className.contains("<")) {
            className = className.substring(0, className.indexOf("<"));
        }
        if (!types.containsKey(className) && className.startsWith("Q")) {
            className = className.substring(1);
        }
        if ((weaveType = types.get(className)) == null) {
            return "Object";
        }
        return weaveType;
    }

    private String toJavaName(String weaveName) {
        return weaveName.replaceAll(NameIdentifier.SEPARATOR(), ".");
    }
}

