/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.ls.DataWeaveJarIndexer;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.dfl.ui.ls.MuleModuleDefinitionsService;
import org.mule.tooling.utils.SilentRunner;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Option;

public class EclipseWeaveResourceResolver
implements WeaveResourceResolver {
    private IMuleProject project;
    private EclipseVirtualFileSystem eclipseVirtualFileSystem;

    public EclipseWeaveResourceResolver(IMuleProject project, EclipseVirtualFileSystem eclipseVirtualFileSystem) {
        this.project = project;
        this.eclipseVirtualFileSystem = eclipseVirtualFileSystem;
    }

    public Option<WeaveResource> resolve(NameIdentifier name) {
        return (Option)SilentRunner.runOrElse(() -> {
            String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            Optional<VirtualFile> inMemoryFile = this.eclipseVirtualFileSystem.getInMemoryFile("synthetic:" + weaveFilePath);
            if (inMemoryFile.isPresent()) {
                return Option.apply((Object)WeaveResource.apply((VirtualFile)inMemoryFile.get()));
            }
            Path relativePath = new Path(weaveFilePath);
            List<IFolder> sourceFolders = EclipseWeaveResourceResolver.getSourceFolders(this.project);
            Optional<IFolder> found = sourceFolders.stream().filter(folder -> folder.exists((IPath)relativePath)).findFirst();
            if (found.isPresent()) {
                IFile file = found.get().getFile((IPath)relativePath);
                IPath fullPath = file.getFullPath();
                URI createPlatformResourceURI = URI.createPlatformResourceURI((String)fullPath.toString());
                return Option.apply((Object)WeaveResource.apply((String)createPlatformResourceURI.toString(), (String)MuleResourceUtils.readContents((IStorage)file, (Charset)StandardCharsets.UTF_8)));
            }
            DataWeaveJarIndexer instance = DataWeaveJarIndexer.getInstance(this.project);
            Optional<WeaveResource> resolveResource = instance.resolveResource(name);
            return Option.apply((Object)resolveResource.orElseGet(() -> MuleModuleDefinitionsService.getInstance(this.project).resolveResource(name).orElse(null)));
        }, Option::empty);
    }

    public static List<IFolder> getSourceFolders(IMuleProject project) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        SilentRunner.run(() -> {
            IPackageFragmentRoot[] rootFragments;
            IPackageFragmentRoot[] iPackageFragmentRootArray = rootFragments = project.getJavaProject().getAllPackageFragmentRoots();
            int n = rootFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot.getKind() == 1 && fragmentRoot.getResource() instanceof IFolder) {
                    result.add((IFolder)fragmentRoot.getResource());
                }
                ++n2;
            }
        });
        return result;
    }
}

