/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.dfl.ui.ls.DataWeaveJarIndexer;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.ls.DataWeaveProjectIndexer;
import org.mule.tooling.dfl.ui.ls.EclipseDocumentVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseResourceVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseSimpleVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseWeaveResourceResolver;
import org.mule.tooling.dfl.ui.ls.MuleModuleDefinitionsService;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.weave.v2.editor.ChangeListener;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Option;

public class EclipseVirtualFileSystem
implements VirtualFileSystem,
IMuleProjectComponent,
FileChangedEventListener,
IClasspathEventListener {
    private static final String DWL_EXTENSION = ".dwl";
    private static final String UNABLE_TO_TRAVERSE_JAR_FILES_MESSAGE = "Unable to traverse jar files in search of DataWeaveFiles";
    private static final String UNABLE_TO_INVALIDATE_DW_FILES_FROM_JARS = "Unable to invalidate DataWeave files inside jar";
    private static final String UNABLE_TO_RETRIEVE_FILES_FROM_FILE_SYSTEM_MESSAGE = "Unable to retrieve DataWeave files from VirtualFileSystem";
    private IMuleProject project;
    private List<ChangeListener> cls;
    private EventBus eventBus;
    private EventBusHelper helper;
    private Map<String, EclipseDocumentVirtualFile> inMemoryFiles;
    private Map<String, Integer> inMemoryFilesHash;

    public EclipseVirtualFileSystem(IMuleProject project, EventBus eventBus) {
        this.eventBus = eventBus;
        this.project = project;
        this.helper = new EventBusHelper();
        this.cls = new ArrayList<ChangeListener>();
        this.inMemoryFiles = new HashMap<String, EclipseDocumentVirtualFile>();
        this.inMemoryFilesHash = new HashMap<String, Integer>();
        this.helper.registerListener(eventBus, CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.helper.registerListener(eventBus, CoreEventTypes.ON_JAR_REMOVED, (IEventHandler)this);
        this.helper.registerListener(eventBus, CoreEventTypes.ON_EXTENSION_REMOVED, (IEventHandler)this);
    }

    public Optional<VirtualFile> getInMemoryFile(String uri) {
        return Optional.ofNullable((VirtualFile)this.inMemoryFiles.get(uri));
    }

    public VirtualFile getOrCreate(String uri, IDocument document) {
        if (this.inMemoryFiles.containsKey(uri)) {
            EclipseDocumentVirtualFile virtualFile = this.inMemoryFiles.get(uri);
            if (virtualFile.getDocument() != document) {
                virtualFile.setDocument(document);
                this.fireFileChanged(virtualFile);
            } else if (this.inMemoryFilesHash.containsKey(uri) && !this.inMemoryFilesHash.get(uri).equals(document.get().hashCode())) {
                this.fireFileChanged(virtualFile);
            }
            return virtualFile;
        }
        EclipseDocumentVirtualFile virtualFile = this.createFile(uri, document);
        this.inMemoryFiles.put(uri, virtualFile);
        this.inMemoryFilesHash.put(uri, document.get().hashCode());
        return virtualFile;
    }

    public EclipseDocumentVirtualFile createFile(String url, IDocument document) {
        return new EclipseDocumentVirtualFile(this.project, this, document, url, null);
    }

    public Optional<IEditorInput> resolveEditorInput(String nameIdentifier) {
        return (Optional)SilentRunner.runOrElse(() -> {
            NameIdentifier name = NameIdentifier.apply((String)nameIdentifier, (Option)Option.empty());
            Optional<IEditorInput> maybeEditorInput = DataWeaveProjectIndexer.getInstance(this.project).resolveEditorInput(name);
            if (maybeEditorInput.isPresent()) {
                return maybeEditorInput;
            }
            return DataWeaveJarIndexer.getInstance(this.project).resolveEditorInput(nameIdentifier);
        }, Optional::empty);
    }

    public void remove(String url) {
        EclipseDocumentVirtualFile remove = this.inMemoryFiles.remove(url);
        if (remove != null) {
            remove.dispose();
        }
    }

    public void changeListener(ChangeListener cl) {
        if (cl != null) {
            this.cls.add(cl);
        } else {
            System.out.println("Null Change Listener");
        }
    }

    public VirtualFile file(String path) {
        IFile[] ifile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(path).toURI());
        if (ifile != null && ifile.length > 0) {
            return new EclipseResourceVirtualFile(this.project.getJavaProject(), ifile[0], this, null);
        }
        Optional<VirtualFile> resolveVirtualFile = DataWeaveJarIndexer.getInstance(this.project).resolveVirtualFile(path);
        if (resolveVirtualFile.isPresent()) {
            return resolveVirtualFile.get();
        }
        return MuleModuleDefinitionsService.getInstance(this.project).resolveVirtualFile(path).orElse(null);
    }

    public void removeChangeListener(ChangeListener listener) {
        boolean remove = this.cls.remove(listener);
        if (!remove) {
            System.out.println("Unable to remove listener " + String.valueOf(listener));
        }
    }

    public void onChanged(IFile file) {
        EclipseResourceVirtualFile vf = new EclipseResourceVirtualFile(this.project.getJavaProject(), file, this, null);
        this.fireFileChanged(vf);
    }

    public void fireFileChanged(VirtualFile vf) {
        for (ChangeListener changeListener : new ArrayList<ChangeListener>(this.cls)) {
            if (changeListener != null) {
                changeListener.onChanged(vf);
                continue;
            }
            System.out.println("Null Change Listener");
        }
    }

    public void fireFileDeleted(VirtualFile vf) {
        for (ChangeListener changeListener : new ArrayList<ChangeListener>(this.cls)) {
            if (changeListener != null) {
                changeListener.onDeleted(vf);
                continue;
            }
            System.out.println("Null Change Listener");
        }
    }

    public WeaveResourceResolver asResourceResolver() {
        return new EclipseWeaveResourceResolver(this.project, this);
    }

    public void init() {
        this.helper.registerListener(this.eventBus, CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)this);
    }

    public void stop() {
        this.helper.unregister();
    }

    public static EclipseVirtualFileSystem getInstance(IMuleProject muleProject) {
        return (EclipseVirtualFileSystem)muleProject.getProjectComponent(EclipseVirtualFileSystem.class);
    }

    public void onFileChanged(FileChangedEvent event) {
        IFile file = event.getFile();
        if (EclipseVirtualFileSystem.isWeaveFile(file) && file.getProject() == this.project.getProject()) {
            EclipseResourceVirtualFile vf = new EclipseResourceVirtualFile(this.project.getJavaProject(), file, this, null);
            this.fireFileChanged(vf);
        }
    }

    public static boolean isWeaveFile(IFile file) {
        String fileExtension = file.getFileExtension();
        return fileExtension != null && fileExtension.equalsIgnoreCase("dwl");
    }

    public void onChanged(VirtualFile vf) {
        this.fireFileChanged(vf);
    }

    public Iterator<VirtualFile> listFiles() {
        List<VirtualFile> foundInLocalRepo = DataWeaveProjectIndexer.getInstance(this.project).listFiles();
        List<VirtualFile> foundInJars = DataWeaveJarIndexer.getInstance(this.project).listFiles();
        List<VirtualFile> foundInMuleModules = MuleModuleDefinitionsService.getInstance(this.project).listFiles();
        ArrayList joinedList = new ArrayList();
        Stream.of(foundInLocalRepo, foundInJars, foundInMuleModules).forEach(joinedList::addAll);
        return joinedList.iterator();
    }

    public Optional<VirtualFile> file(NameIdentifier name) {
        return (Optional)SilentRunner.runOrElse(() -> {
            Path relativePath = new Path(NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/"));
            List<IFolder> sourceFolders = EclipseWeaveResourceResolver.getSourceFolders(this.project);
            Optional<IFolder> found = sourceFolders.stream().filter(folder -> folder.exists((IPath)relativePath)).findFirst();
            if (found.isPresent()) {
                IFile file = found.get().getFile((IPath)relativePath);
                return Optional.of(new EclipseResourceVirtualFile(this.project.getJavaProject(), file, this, name));
            }
            DataWeaveJarIndexer instance = DataWeaveJarIndexer.getInstance(this.project);
            return instance.resolveVirtualFile(name);
        }, Optional::empty);
    }

    private List<VirtualFile> traverseJarFragments(IPackageFragmentRoot fragment) throws JavaModelException, IOException, CoreException {
        ArrayList<VirtualFile> weaveFiles = new ArrayList<VirtualFile>();
        IJavaElement[] packages = fragment.getChildren();
        weaveFiles.addAll(this.getWeaveVirtualFilesFromClasspath(fragment, fragment.getNonJavaResources()));
        IJavaElement[] iJavaElementArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement packageFragment = iJavaElementArray[n2];
            if (packageFragment instanceof IPackageFragment) {
                weaveFiles.addAll(this.getWeaveVirtualFilesFromClasspath(fragment, ((IPackageFragment)packageFragment).getNonJavaResources()));
            }
            ++n2;
        }
        return weaveFiles;
    }

    private List<VirtualFile> getWeaveVirtualFilesFromClasspath(IPackageFragmentRoot fragment, Object[] resources) throws IOException, CoreException {
        ArrayList<VirtualFile> vfiles = new ArrayList<VirtualFile>();
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource jarEntry;
            boolean isWeaveEntry;
            Object object = objectArray[n2];
            if (object instanceof IJarEntryResource && (isWeaveEntry = (jarEntry = (IJarEntryResource)object).getName().endsWith(DWL_EXTENSION))) {
                String jarEntryUri = jarEntry.getFullPath().toString();
                String content = new String(jarEntry.getContents().readAllBytes());
                vfiles.add(new EclipseSimpleVirtualFile(jarEntryUri, content, this, NameIdentifier.fromPath((String)jarEntryUri)));
            }
            ++n2;
        }
        return vfiles;
    }

    private List<VirtualFile> getWeaveVirtualFilesFromFileSystem(FileSystem fileSystem) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<java.nio.file.Path> fileList = Files.walk(fileSystem.getPath(fileSystem.getSeparator(), ""), new FileVisitOption[0]);){
                List weaveFiles = fileList.filter(p -> p.getFileName() != null && p.getFileName().toString().endsWith(DWL_EXTENSION)).collect(Collectors.toList());
                for (java.nio.file.Path path : weaveFiles) {
                    String fileUri = path.toAbsolutePath().toString();
                    String content = new String(Files.readAllBytes(path));
                    list.add(new EclipseSimpleVirtualFile(fileUri, content, this, NameIdentifier.fromPath((String)fileUri)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)UNABLE_TO_RETRIEVE_FILES_FROM_FILE_SYSTEM_MESSAGE, (Throwable)e);
            return Collections.emptyList();
        }
        return list;
    }

    public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
        IJavaProject javaProject = muleProject.getJavaProject();
        ArrayList<VirtualFile> weaveFiles = new ArrayList<VirtualFile>();
        try {
            List fragments = Stream.of(javaProject.getAllPackageFragmentRoots()).filter(f -> f.getElementName().contains(file.getName())).collect(Collectors.toList());
            for (IPackageFragmentRoot fragment : fragments) {
                weaveFiles.addAll(this.traverseJarFragments(fragment));
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)UNABLE_TO_TRAVERSE_JAR_FILES_MESSAGE, (Throwable)e);
        }
        for (VirtualFile virtualFile : weaveFiles) {
            this.fireFileChanged(virtualFile);
        }
        DataWeaveLanguageService service = DataWeaveLanguageService.getInstance(muleProject);
        service.getWeaveToolingService().invalidateAll();
    }

    public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
        try {
            java.nio.file.Path pathToFile = Paths.get(file.getAbsolutePath(), "");
            FileSystem fs = FileSystems.newFileSystem(pathToFile);
            List<VirtualFile> weaveVirtualFiles = this.getWeaveVirtualFilesFromFileSystem(fs);
            for (VirtualFile weaveVirtualFile : weaveVirtualFiles) {
                this.fireFileDeleted(weaveVirtualFile);
            }
            DataWeaveLanguageService service = DataWeaveLanguageService.getInstance(muleProject);
            service.getWeaveToolingService().invalidateAll();
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)UNABLE_TO_INVALIDATE_DW_FILES_FROM_JARS, (Throwable)e);
        }
    }

    public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
    }

    public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
    }
}

