/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.xtext.util.StringInputStream;
import org.mule.tooling.utils.SilentRunner;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;

public class EclipseResourceVirtualFile
implements VirtualFile {
    private IFile resource;
    private VirtualFileSystem vfs;
    private NameIdentifier nameIdentifier;
    private IJavaProject project;

    public EclipseResourceVirtualFile(IJavaProject project, IFile resource, VirtualFileSystem vfs, NameIdentifier nameIdentifier) {
        this.project = project;
        this.resource = resource;
        this.vfs = vfs;
        this.nameIdentifier = nameIdentifier;
    }

    public VirtualFileSystem fs() {
        return this.vfs;
    }

    public String path() {
        return this.resource.getFullPath().toString();
    }

    public String read() {
        return (String)SilentRunner.run(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream contents = this.resource.getContents(true);){
                return IOUtils.toString((InputStream)contents, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, (Object)"");
    }

    public boolean readOnly() {
        return this.resource.isReadOnly();
    }

    public boolean write(String content) {
        SilentRunner.run(() -> this.resource.setContents((InputStream)new StringInputStream(content), 2, (IProgressMonitor)new NullProgressMonitor()));
        return true;
    }

    public String url() {
        return (String)SilentRunner.run(() -> this.resource.getLocationURI().toURL().getFile(), (Object)"");
    }

    public NameIdentifier getNameIdentifier() {
        if (this.nameIdentifier != null) {
            return this.nameIdentifier;
        }
        return (NameIdentifier)SilentRunner.runOrElse(() -> {
            IPackageFragmentRoot[] rootFragments;
            IPath resourcePath = this.resource.getFullPath();
            IPackageFragmentRoot[] iPackageFragmentRootArray = rootFragments = this.project.getAllPackageFragmentRoots();
            int n = rootFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot.getKind() == 1 && fragmentRoot.getResource() instanceof IFolder) {
                    IPath sourceFolderPath = fragmentRoot.getResource().getFullPath();
                    String folderPath = sourceFolderPath.toString();
                    if (resourcePath.toString().startsWith(folderPath)) {
                        IPath relativePath = resourcePath.makeRelativeTo(sourceFolderPath);
                        this.nameIdentifier = NameIdentifierHelper.fromWeaveFilePath((String)relativePath.toString(), (String)"/");
                        return this.nameIdentifier;
                    }
                }
                ++n2;
            }
            return NameIdentifierHelper.fromWeaveFilePath((String)this.url());
        }, () -> NameIdentifierHelper.fromWeaveFilePath((String)this.url(), (String)"/"));
    }
}

