/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.net.URI;
import java.util.Optional;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.ls.DataWeaveJarIndexer;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.utils.SilentRunner;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;

public class EclipseDocumentVirtualFile
implements VirtualFile,
IDocumentListener {
    public static final String SYNTHETIC_PROTOCOL = "synthetic:";
    private EclipseVirtualFileSystem vfs;
    private IDocument document;
    private String uri;
    private NameIdentifier nameIdentifier;
    private IMuleProject project;

    public EclipseDocumentVirtualFile(IMuleProject project, EclipseVirtualFileSystem vfs, IDocument document, String uri, NameIdentifier nameIdentifier) {
        this.project = project;
        this.vfs = vfs;
        this.document = document;
        this.uri = uri;
        this.nameIdentifier = nameIdentifier;
        this.document.addDocumentListener((IDocumentListener)this);
    }

    public IDocument getDocument() {
        return this.document;
    }

    public VirtualFileSystem fs() {
        return this.vfs;
    }

    public String path() {
        return this.uri;
    }

    public String read() {
        return this.document.get();
    }

    public boolean readOnly() {
        return false;
    }

    public boolean write(String content) {
        this.document.set(content);
        return true;
    }

    public String url() {
        return this.uri;
    }

    public NameIdentifier getNameIdentifier() {
        URI parsedURI = URI.create(this.uri);
        if (this.uri.startsWith(SYNTHETIC_PROTOCOL)) {
            IPath resourcePath = Path.fromOSString((String)parsedURI.getPath());
            NameIdentifier fromWeaveFilePath = NameIdentifierHelper.fromWeaveFilePath((String)resourcePath.toString(), (String)"/");
            return fromWeaveFilePath;
        }
        if (this.nameIdentifier != null) {
            return this.nameIdentifier;
        }
        return (NameIdentifier)SilentRunner.runOrElse(() -> {
            IPackageFragmentRoot[] rootFragments;
            IPath resourcePath = Path.fromOSString((String)parsedURI.getPath());
            IPackageFragmentRoot[] iPackageFragmentRootArray = rootFragments = this.project.getJavaProject().getAllPackageFragmentRoots();
            int n = rootFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot.getKind() == 1 && fragmentRoot.getResource() instanceof IFolder) {
                    IPath sourceFolderPath = fragmentRoot.getResource().getFullPath();
                    String folderPath = sourceFolderPath.toString();
                    if (resourcePath.toString().contains(folderPath)) {
                        int indexOf = resourcePath.toString().indexOf(folderPath);
                        String relativePath = resourcePath.toString().substring(indexOf + folderPath.length());
                        this.nameIdentifier = NameIdentifierHelper.fromWeaveFilePath((String)relativePath, (String)"/");
                        return this.nameIdentifier;
                    }
                }
                ++n2;
            }
            Optional<NameIdentifier> resolveResource = DataWeaveJarIndexer.getInstance(this.project).resolveResource(this.uri);
            resolveResource.ifPresent(name -> {
                this.nameIdentifier = name;
            });
            return resolveResource.orElse(NameIdentifierHelper.fromWeaveFilePath((String)this.uri));
        }, () -> NameIdentifierHelper.fromWeaveFilePath((String)this.uri, (String)"/"));
    }

    public void setDocument(IDocument document) {
        this.document.removeDocumentListener((IDocumentListener)this);
        this.document = document;
        this.document.addDocumentListener((IDocumentListener)this);
    }

    public void dispose() {
        this.document.removeDocumentListener((IDocumentListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.vfs.fireFileChanged(this);
    }
}

