/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.dfl.ui.ls.EclipseResourceVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.dfl.ui.ls.EclipseWeaveResourceResolver;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;

public class DataWeaveProjectIndexer
implements IMuleProjectComponent,
FileChangedEventListener {
    private IMuleProject muleProject;
    private EventBus eventBus;
    private EventBusHelper helper;
    private Map<String, VirtualFile> elements;

    public DataWeaveProjectIndexer(IMuleProject muleProject, EventBus eventBus) {
        this.muleProject = muleProject;
        this.elements = new HashMap<String, VirtualFile>();
        this.eventBus = eventBus;
        this.helper = new EventBusHelper();
    }

    public void init() {
        this.helper.registerListener(this.eventBus, CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)this);
        List<IFolder> sourceFolders = EclipseWeaveResourceResolver.getSourceFolders(this.muleProject);
        sourceFolders.parallelStream().forEach(this::collectFiles);
    }

    private void collectFiles(IFolder folder) {
        SilentRunner.run(() -> {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    if (EclipseVirtualFileSystem.isWeaveFile(file)) {
                        this.addWeaveFile(file);
                    }
                } else if (resource instanceof IFolder) {
                    this.collectFiles((IFolder)resource);
                }
                ++n2;
            }
        });
    }

    public void stop() {
        this.helper.unregister();
    }

    public VirtualFile[] listFilesByNameIdentifier(String filter) {
        return (VirtualFile[])this.elements.values().stream().filter(resource -> resource.getNameIdentifier().name().startsWith(filter)).toArray(VirtualFile[]::new);
    }

    public List<VirtualFile> listFiles() {
        return new ArrayList<VirtualFile>(this.elements.values());
    }

    public Optional<IEditorInput> resolveEditorInput(NameIdentifier name) {
        Path relativePath = new Path(NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/"));
        List<IFolder> sourceFolders = EclipseWeaveResourceResolver.getSourceFolders(this.muleProject);
        Optional<IFolder> found = sourceFolders.stream().filter(folder -> folder.exists((IPath)relativePath)).findFirst();
        return found.map(folder -> new FileEditorInput(folder.getFile((IPath)relativePath)));
    }

    public static DataWeaveProjectIndexer getInstance(IMuleProject project) {
        return (DataWeaveProjectIndexer)project.getProjectComponent(DataWeaveProjectIndexer.class);
    }

    public void onFileChanged(FileChangedEvent event) {
        IFile file = event.getFile();
        List<IFolder> sourceFolders = EclipseWeaveResourceResolver.getSourceFolders(this.muleProject);
        Optional<IFolder> isSourceFile = sourceFolders.stream().filter(folder -> file.getFullPath().toString().startsWith(folder.getFullPath().toString())).findFirst();
        if (isSourceFile.isPresent() && EclipseVirtualFileSystem.isWeaveFile(file)) {
            if (event.isEventType(FileChangedEvent.ChangeType.DELETED)) {
                this.elements.remove(file.getFullPath().toString());
            } else if (event.isEventType(FileChangedEvent.ChangeType.CREATED)) {
                this.addWeaveFile(file);
            }
        }
    }

    private void addWeaveFile(IFile file) {
        this.elements.put(file.getFullPath().toString(), new EclipseResourceVirtualFile(this.muleProject.getJavaProject(), file, EclipseVirtualFileSystem.getInstance(this.muleProject), null));
    }
}

