/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.event.IMuleModuleManagerRestartedListener;
import org.mule.tooling.core.event.IMuleProjectModifiedListener;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.ls.EclipseDocumentVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.dfl.ui.ls.JavaModuleResourceResolver;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.weave.v2.codegen.CodeGenerator$;
import org.mule.weave.v2.completion.DataFormatDescriptor;
import org.mule.weave.v2.completion.DataFormatDescriptorProvider;
import org.mule.weave.v2.completion.DataFormatProperty;
import org.mule.weave.v2.completion.SuggestionResult;
import org.mule.weave.v2.editor.FunctionDefinition;
import org.mule.weave.v2.editor.ImplicitInput;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.editor.SpecificModuleResourceResolver;
import org.mule.weave.v2.editor.ValidationMessages;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.editor.VirtualFileSystem;
import org.mule.weave.v2.editor.VisibleElement;
import org.mule.weave.v2.editor.WeaveDoc;
import org.mule.weave.v2.editor.WeaveDocumentToolingService;
import org.mule.weave.v2.editor.WeaveToolingService;
import org.mule.weave.v2.editor.WeaveToolingTypeHelper;
import org.mule.weave.v2.el.metadata.WeaveTypesConverter;
import org.mule.weave.v2.hover.HoverMessage;
import org.mule.weave.v2.parser.MappingParser;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper;
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.CompilationPhase;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.scaffolding.ScaffoldingConfiguration;
import org.mule.weave.v2.scaffolding.ScaffoldingFilter;
import org.mule.weave.v2.scaffolding.ScaffoldingService;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class DataWeaveLanguageService
implements IMuleProjectComponent,
IClasspathEventListener,
IMuleProjectModifiedListener,
IMuleModuleManagerRestartedListener {
    private IProject project;
    private WeaveToolingService dwTextDocumentService;
    private EclipseVirtualFileSystem evfs;
    private EventBusHelper helper;
    private EventBus eventBus;
    private DataFormatDescriptorProvider dataFormatDescriptorProvider;
    private ScaffoldingService scaffoldingService = new ScaffoldingService();
    private WeaveTypesConverter weaveTypesConverter = new WeaveTypesConverter();
    private static final int COLLECTION_ELEMENT_AMOUNT = 2;

    public DataWeaveLanguageService(IMuleProject project, EventBus eventBus) {
        this.eventBus = eventBus;
        this.helper = new EventBusHelper();
        this.project = project.getProject();
        this.evfs = EclipseVirtualFileSystem.getInstance(project);
        this.dataFormatDescriptorProvider = new DataFormatDescriptorProvider(){
            private DataFormatDescriptor[] descriptors = null;

            public DataFormatDescriptor[] dataFormats() {
                if (this.descriptors == null) {
                    List mimeTypes = WeaveEngineHelperManager.getMimeTypeManager().getMimeTypes();
                    this.descriptors = (DataFormatDescriptor[])mimeTypes.stream().map(mimeType -> {
                        List writerOptions = WeaveEngineHelperManager.getWriterOptions((String)mimeType);
                        DataFormatProperty[] writerProperties = (DataFormatProperty[])writerOptions.stream().map(writerOption -> new DataFormatProperty(writerOption.getName(), writerOption.getDescription(), writerOption.getType(), writerOption.getPossibleValues().toArray(new String[0]))).toArray(DataFormatProperty[]::new);
                        return new DataFormatDescriptor(mimeType, writerProperties, new DataFormatProperty[0]);
                    }).toArray(DataFormatDescriptor[]::new);
                }
                return this.descriptors;
            }
        };
    }

    public void init() {
        this.helper.registerListener(this.eventBus, CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.helper.registerListener(this.eventBus, CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.helper.registerListener(this.eventBus, CoreEventTypes.ON_EXTENSION_REMOVED, (IEventHandler)this);
        this.helper.registerListener(this.eventBus, CoreEventTypes.ON_MULE_PROJECT_MODIFIED, (IEventHandler)this);
        this.helper.registerListener(this.eventBus, CoreEventTypes.ON_MULE_MODULE_MANAGER_RESTARTED, (IEventHandler)this);
    }

    public Option<Link> declaration(URI uri, IXtextDocument document, int offset, IDataSenseProvider dataSenseProvider) {
        VirtualFile virtualFile = this.evfs.getOrCreate(uri.toString(), (IDocument)document);
        return this.doOpen(virtualFile, dataSenseProvider, false).definitionLink(offset);
    }

    public ImplicitInput availableContext(URI uri, IXtextDocument document, IDataSenseProvider dataSenseProvider, int location) {
        VirtualFile virtualFile = this.evfs.getOrCreate(uri.toString(), (IDocument)document);
        WeaveDocumentToolingService doOpen = this.doOpen(virtualFile, dataSenseProvider, false);
        VisibleElement[] visibleLocalVariables = doOpen.visibleLocalVariables(location);
        ImplicitInput inputs = new ImplicitInput();
        VisibleElement[] visibleElementArray = visibleLocalVariables;
        int n = visibleLocalVariables.length;
        int n2 = 0;
        while (n2 < n) {
            VisibleElement visibleElement = visibleElementArray[n2];
            inputs.addInput(visibleElement.name(), visibleElement.weaveType());
            ++n2;
        }
        return inputs;
    }

    public WeaveToolingService getWeaveToolingService() {
        if (this.dwTextDocumentService == null) {
            this.dwTextDocumentService = WeaveToolingService.apply((VirtualFileSystem)this.evfs, (DataFormatDescriptorProvider)this.dataFormatDescriptorProvider, (SpecificModuleResourceResolver[])new SpecificModuleResourceResolver[]{new SpecificModuleResourceResolver("java", (WeaveResourceResolver)new JavaModuleResourceResolver(JavaCore.create((IProject)this.project)))});
        }
        return this.dwTextDocumentService;
    }

    public ValidationMessages validate(URI uri, IXtextDocument document, IDataSenseProvider dataSenseProvider, boolean syntaxOnly) {
        VirtualFile virtualFile;
        if (ExpressionUtils.isExpression((String)document.get())) {
            String textToValidate = ExpressionUtils.getExpressionValue((String)document.get());
            virtualFile = this.evfs.getOrCreate(uri.toString(), (IDocument)new Document(textToValidate));
        } else {
            virtualFile = this.evfs.getOrCreate(uri.toString(), (IDocument)document);
        }
        WeaveDocumentToolingService doOpen = this.doOpen(virtualFile, dataSenseProvider, false);
        if (syntaxOnly) {
            return doOpen.parseCheck();
        }
        return doOpen.typeCheck();
    }

    public FunctionDefinition[] availableModuleFunctions(String module) {
        NameIdentifier moduleName = NameIdentifier.apply((String)module, (Option)Option.empty());
        return this.availableModuleFunctions(moduleName);
    }

    public Optional<String> moduleDocumentation(NameIdentifier moduleName) {
        Optional<VirtualFile> file = this.evfs.file(moduleName);
        if (file.isPresent()) {
            WeaveDocumentToolingService open = this.getWeaveToolingService().open(file.get(), ImplicitInput.apply(), Option.empty());
            Option documentation = open.documentation();
            if (documentation.isDefined()) {
                return Optional.of(((WeaveDoc)documentation.get()).markdownDoc());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public FunctionDefinition[] availableModuleFunctions(NameIdentifier moduleName) {
        Optional<VirtualFile> file = this.evfs.file(moduleName);
        if (file.isPresent()) {
            WeaveDocumentToolingService open = this.getWeaveToolingService().open(file.get(), ImplicitInput.apply(), Option.empty());
            return open.availableFunctions();
        }
        return new FunctionDefinition[0];
    }

    public boolean canBeSubstituted(WeaveType expected, WeaveType actual) {
        return WeaveToolingTypeHelper.canBeSubstituted((WeaveType)expected, (WeaveType)actual);
    }

    public boolean canBeAssigned(WeaveType expected, WeaveType actual) {
        return WeaveToolingTypeHelper.canBeAssigned((WeaveType)expected, (WeaveType)actual);
    }

    public WeaveType typeOf(URI uri, IXtextDocument document, int startOffset, int endOffset, IDataSenseProvider dataSenseProvider) {
        VirtualFile virtualFile = this.evfs.getOrCreate(uri.toString(), (IDocument)document);
        WeaveDocumentToolingService doOpen = this.doOpen(virtualFile, dataSenseProvider, false);
        return doOpen.typeOf(startOffset, endOffset);
    }

    public ValidationMessages validateScript(IDocument document, IDataSenseProvider propagationInfo, boolean syntaxOnly) {
        EclipseDocumentVirtualFile virtualFile;
        if (ExpressionUtils.isExpression((String)document.get())) {
            String textToValidate = ExpressionUtils.getExpressionValue((String)document.get());
            virtualFile = this.evfs.createFile("synthetic:/fakefile.dwl", (IDocument)new Document(textToValidate));
        } else {
            virtualFile = this.evfs.createFile("synthetic:/fakefile.dwl", document);
        }
        try {
            WeaveDocumentToolingService doOpen = this.doOpenInMemory(virtualFile, propagationInfo, true);
            if (syntaxOnly) {
                ValidationMessages validationMessages = doOpen.parseCheck();
                return validationMessages;
            }
            ValidationMessages validationMessages = doOpen.typeCheck();
            return validationMessages;
        }
        finally {
            virtualFile.dispose();
        }
    }

    public void stop() {
        this.helper.unregister();
    }

    private WeaveDocumentToolingService doOpenInMemory(VirtualFile vf, IDataSenseProvider dataSenseProvider, boolean useOutputMetadata) {
        Optional<Object> mayBeOutputMetadata = useOutputMetadata ? dataSenseProvider.expectedOutput() : Optional.empty();
        Option scalaMaybeOutput = mayBeOutputMetadata.isPresent() ? Option.apply((Object)((WeaveType)mayBeOutputMetadata.get())) : Option.empty();
        WeaveDocumentToolingService open = this.getWeaveToolingService().openInMemory(vf, dataSenseProvider.implicitInput(), scalaMaybeOutput);
        return open;
    }

    private WeaveDocumentToolingService doOpen(VirtualFile vf, IDataSenseProvider dataSenseProvider, boolean useOutputMetadata) {
        Optional<Object> mayBeOutputMetadata = useOutputMetadata ? dataSenseProvider.expectedOutput() : Optional.empty();
        Option scalaMaybeOutput = mayBeOutputMetadata.isPresent() ? Option.apply((Object)((WeaveType)mayBeOutputMetadata.get())) : Option.empty();
        WeaveDocumentToolingService open = this.getWeaveToolingService().open(vf, dataSenseProvider.implicitInput(), scalaMaybeOutput);
        return open;
    }

    public static DataWeaveLanguageService getInstance(IMuleProject muleProject) {
        return (DataWeaveLanguageService)muleProject.getProjectComponent(DataWeaveLanguageService.class);
    }

    public SuggestionResult completion(URI uri, IDocument document, int offset, IDataSenseProvider dataSenseProvider) {
        VirtualFile virtualFile = this.evfs.getOrCreate(uri.toString(), document);
        return this.doOpen(virtualFile, dataSenseProvider, true).completion(offset);
    }

    public Option<HoverMessage> hover(String uri, IDocument document, int offset, IDataSenseProvider dataSenseProvider) {
        VirtualFile virtualFile = this.evfs.getOrCreate(uri, document);
        return this.doOpen(virtualFile, dataSenseProvider, false).hoverResult(offset);
    }

    public void close(String uri) {
        this.getWeaveToolingService().close(uri);
        this.evfs.remove(uri);
    }

    public static String toHtml(String text) {
        if (text == null) {
            return null;
        }
        List<Extension> extensions = Arrays.asList(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(text);
        HtmlRenderer renderer = HtmlRenderer.builder().extensions(extensions).build();
        return renderer.render(document);
    }

    public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
        this.invalidate();
    }

    private void invalidate() {
        if (this.dwTextDocumentService != null) {
            this.dwTextDocumentService.invalidateAll();
        }
    }

    public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
        this.invalidate();
    }

    public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
        this.invalidate();
    }

    public void onMuleProjectModified(IMuleProject muleProject, String propertyName) {
        this.invalidate();
    }

    public void onMuleModuleManagerRestarted(IMuleModuleManager muleModuleManager) {
        this.invalidate();
    }

    public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
    }

    public String scaffoldSampleData(MetadataType model, String mimeType, Map<String, Object> writerProperties) {
        WeaveType weaveType = this.weaveTypesConverter.toWeaveType(model);
        return this.scaffoldingService.scaffold(weaveType, mimeType, writerProperties, new ScaffoldingConfiguration(2));
    }

    public String scaffoldSampleData(MetadataType model, String mimeType, Map<String, Object> writerProperties, ScaffoldingFilter scaffoldingFilter) {
        WeaveType weaveType = this.weaveTypesConverter.toWeaveType(model);
        return this.scaffoldingService.scaffold(weaveType, mimeType, writerProperties, new ScaffoldingConfiguration(2), scaffoldingFilter);
    }

    public String changeOutputDirective(String dflScript, String dataWeaveMimeType) {
        PhaseResult parse = MappingParser.parse((CompilationPhase)MappingParser.parsingPhase(), (WeaveResource)WeaveResource.anonymous((String)dflScript), (ParsingContext)ParsingContextFactory.createParsingContext());
        DocumentNode astNode = (DocumentNode)((ParsingResult)parse.getResult()).astNode();
        astNode = AstNodeHelper.updateOutputDirective((DocumentNode)astNode, (OutputDirective)AstNodeHelper.createOutputDirective((String)dataWeaveMimeType));
        return CodeGenerator$.MODULE$.generate((AstNode)astNode);
    }
}

