/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IEditorInput;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.event.IMuleProjectModifiedListener;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.ls.EclipseSimpleVirtualFile;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.weave.v2.editor.VirtualFile;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.WeaveResource;
import scala.Option;

public class DataWeaveJarIndexer
implements IMuleProjectComponent,
IMuleProjectModifiedListener,
IClasspathEventListener {
    private IMuleProject project;
    private WeaveEntryIndex index;
    private volatile boolean initialized = false;
    private EventBusHelper helper = new EventBusHelper();

    public DataWeaveJarIndexer(IMuleProject project, EventBus eventBus) {
        this.project = project;
        this.index = new WeaveEntryIndex();
        this.helper.registerListener(eventBus, CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.helper.registerListener(eventBus, CoreEventTypes.ON_JAR_REMOVED, (IEventHandler)this);
        this.helper.registerListener(eventBus, CoreEventTypes.ON_MULE_PROJECT_MODIFIED, (IEventHandler)this);
        this.helper.registerListener(eventBus, CoreEventTypes.ON_EXTENSION_REMOVED, (IEventHandler)this);
    }

    public void init() {
        this.load();
    }

    public Set<NameIdentifier> getModulesNames() {
        return this.index.getModulesNames();
    }

    public Optional<IEditorInput> resolveEditorInput(String nameIdentifier) {
        return this.index.getEntryFromName(NameIdentifier.apply((String)nameIdentifier, (Option)Option.empty())).map(entry -> new JarEntryEditorInput((IStorage)entry.getJarEntry()));
    }

    public Optional<VirtualFile> resolveVirtualFile(String path) {
        return this.index.getEntryFromPath(path).map(entry -> entry.asVirtualFile(this.project));
    }

    public Optional<VirtualFile> resolveVirtualFile(NameIdentifier nameIdentifier) {
        return this.index.getEntryFromName(nameIdentifier).map(entry -> entry.asVirtualFile(this.project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (!this.initialized) {
            DataWeaveJarIndexer dataWeaveJarIndexer = this;
            synchronized (dataWeaveJarIndexer) {
                if (!this.initialized) {
                    DFLExtendedActivator.getDebugTrace().traceDumpStack(DFLExtendedActivator.JAR_INDEXER_TRACE_ID);
                    SilentRunner.run(() -> {
                        IJavaProject javaProject = this.project.getJavaProject();
                        IPackageFragmentRoot[] rootFragments = javaProject.getPackageFragmentRoots();
                        Predicate<Path> pathFilter = this.getPathFilter(javaProject);
                        ((Stream)Stream.of(rootFragments).parallel()).forEach(fragment -> SilentRunner.run(() -> {
                            if (fragment.getKind() == 2 && fragment.exists()) {
                                Path fragmentPath = fragment.getPath().toFile().toPath();
                                if (pathFilter.test(fragmentPath)) {
                                    DFLExtendedActivator.getDebugTrace().trace(DFLExtendedActivator.JAR_INDEXER_ID, "Indexing: " + String.valueOf(fragment.getPath()));
                                    this.loadFromJar((IPackageFragmentRoot)fragment);
                                } else {
                                    DFLExtendedActivator.getDebugTrace().trace(DFLExtendedActivator.JAR_INDEXER_ID, "Skipping: " + String.valueOf(fragment.getPath()));
                                }
                            }
                        }));
                    });
                    this.initialized = true;
                }
            }
        }
    }

    private Predicate<Path> getPathFilter(IJavaProject javaProject) throws CoreException {
        String vmInstall = VMUtils.getDefaultJvmHome((IJavaProject)javaProject);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vmInstall})) {
            return jarPath -> !jarPath.startsWith(vmInstall);
        }
        return jarPath -> true;
    }

    private void loadFromJar(IPackageFragmentRoot fragment) throws JavaModelException {
        IJavaElement[] packages = fragment.getChildren();
        this.processResources(fragment, fragment.getNonJavaResources());
        IJavaElement[] iJavaElementArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement packageFragment = iJavaElementArray[n2];
            if (packageFragment instanceof IPackageFragment) {
                this.processResources(fragment, ((IPackageFragment)packageFragment).getNonJavaResources());
            }
            ++n2;
        }
    }

    private void processResources(IPackageFragmentRoot fragment, Object[] resources) {
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource jarEntry;
            boolean isWeaveEntry;
            Object resource = objectArray[n2];
            if (resource instanceof IJarEntryResource && (isWeaveEntry = (jarEntry = (IJarEntryResource)resource).getName().endsWith(".dwl"))) {
                this.index.add(jarEntry, fragment);
            }
            ++n2;
        }
    }

    public VirtualFile[] listFilesByNameIdentifier(String filter) {
        return this.index.filter(entry -> entry.nameIdentifier.name().startsWith(filter), this.project);
    }

    public List<VirtualFile> listFiles() {
        return this.index.filesByProject(this.project);
    }

    public void stop() {
        this.unload();
        this.helper.unregister();
    }

    private void unload() {
        this.index.clear();
        this.initialized = false;
    }

    public Optional<WeaveResource> resolveResource(NameIdentifier nameIdentifier) {
        this.load();
        return this.index.getEntryFromName(nameIdentifier).map(entry -> WeaveResource.apply((String)entry.getPath().toString(), (String)entry.getContent()));
    }

    public Optional<NameIdentifier> resolveResource(String path) {
        this.load();
        return this.index.getEntryFromPath(path).map(WeaveEntry::getNameIdentifier);
    }

    public static DataWeaveJarIndexer getInstance(IMuleProject project) {
        return (DataWeaveJarIndexer)project.getProjectComponent(DataWeaveJarIndexer.class);
    }

    public void onMuleProjectModified(IMuleProject muleProject, String propertyName) {
        if (propertyName.equalsIgnoreCase("extensions")) {
            this.unload();
        }
    }

    public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
        this.unload();
    }

    public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
        this.unload();
    }

    public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
        this.unload();
    }

    public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
    }

    private static class WeaveEntry {
        private NameIdentifier nameIdentifier;
        private IPath path;
        private IJarEntryResource jarEntry;
        private IPackageFragmentRoot jar;
        private String content;

        public WeaveEntry(IJarEntryResource jarEntry, IPackageFragmentRoot jar, IPath fullPath, NameIdentifier weaveName) {
            this.jarEntry = jarEntry;
            this.jar = jar;
            this.path = fullPath;
            this.nameIdentifier = weaveName;
            this.content = (String)SilentRunner.run(() -> MuleResourceUtils.readContents((IStorage)jarEntry, (Charset)StandardCharsets.UTF_8), (Object)"");
        }

        public IJarEntryResource getJarEntry() {
            return this.jarEntry;
        }

        public IPackageFragmentRoot getJar() {
            return this.jar;
        }

        public String getContent() {
            return this.content;
        }

        public NameIdentifier getNameIdentifier() {
            return this.nameIdentifier;
        }

        public VirtualFile asVirtualFile(IMuleProject muleProject) {
            return new EclipseSimpleVirtualFile(this.path.toString(), this.content, EclipseVirtualFileSystem.getInstance(muleProject), this.nameIdentifier);
        }

        public IPath getPath() {
            return this.path;
        }
    }

    private static class WeaveEntryIndex {
        private Map<NameIdentifier, WeaveEntry> byName = new HashMap<NameIdentifier, WeaveEntry>();
        private Map<String, WeaveEntry> byPath = new HashMap<String, WeaveEntry>();

        public void add(IJarEntryResource jarEntry, IPackageFragmentRoot jar) {
            IPath fullPath = jarEntry.getFullPath();
            String fullPathText = "archive:file:" + jar.getPath().toString() + "!" + fullPath.toString();
            NameIdentifier weaveName = NameIdentifierHelper.fromWeaveFilePath((String)fullPath.toString(), (String)"/");
            WeaveEntry entry = new WeaveEntry(jarEntry, jar, fullPath, weaveName);
            this.byName.put(weaveName, entry);
            this.byPath.put(fullPathText, entry);
        }

        public Set<NameIdentifier> getModulesNames() {
            return this.byName.keySet();
        }

        public Optional<WeaveEntry> getEntryFromName(NameIdentifier name) {
            return Optional.ofNullable(this.byName.get(name));
        }

        public Optional<WeaveEntry> getEntryFromPath(String path) {
            return Optional.ofNullable(this.byPath.get(path));
        }

        public void clear() {
            this.byName.clear();
            this.byPath.clear();
        }

        public VirtualFile[] filter(Predicate<WeaveEntry> filter, IMuleProject muleProject) {
            return (VirtualFile[])this.byName.values().stream().filter(filter).map(entry -> entry.asVirtualFile(muleProject)).toArray(VirtualFile[]::new);
        }

        public List<VirtualFile> filesByProject(IMuleProject muleProject) {
            return this.byName.values().stream().map(entry -> entry.asVirtualFile(muleProject)).collect(Collectors.toList());
        }
    }
}

