/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.ls.EclipseVirtualFileSystem;
import org.mule.tooling.dfl.ui.utils.XtextDocumentUtils;
import org.mule.tooling.utils.SilentRunner;
import org.mule.weave.v2.editor.Link;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import scala.Option;

public class DataWeaveGoToDeclaration
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IXtextDocument document = (IXtextDocument)textViewer.getDocument();
        URI uri = XtextDocumentUtils.getURI(document);
        IMuleProject project = DataSenseHolder.getProject(uri.toString());
        DataWeaveLanguageService langservice = DataWeaveLanguageService.getInstance(project);
        Option<Link> references = langservice.declaration(uri, document, region.getOffset(), DataSenseHolder.getCurrentDataSenseProvider(uri.toString()));
        if (references.isDefined()) {
            return new IHyperlink[]{new DataWeaveHyperlink((Link)references.get(), textViewer, project)};
        }
        return null;
    }

    public static class DataWeaveHyperlink
    implements IHyperlink {
        private Link link;
        private ITextViewer localDeclaration;
        private IMuleProject project;

        public DataWeaveHyperlink(Link link, ITextViewer localDeclaration, IMuleProject project) {
            this.link = link;
            this.localDeclaration = localDeclaration;
            this.project = project;
        }

        public IRegion getHyperlinkRegion() {
            int startOffset = this.link.linkLocation().location().startPosition().index();
            int endOffset = this.link.linkLocation().location().endPosition().index();
            return new Region(startOffset, endOffset - startOffset);
        }

        public String getTypeLabel() {
            return this.getHyperlinkText();
        }

        public String getHyperlinkText() {
            return "Got to " + this.link.linkLocation().name() + " declaration.";
        }

        public void open() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            boolean localReference = this.link.reference().isLocalReference();
            NameIdentifier referencedNode = this.link.reference().referencedNode();
            int startIndex = referencedNode.location().startPosition().index();
            int endIndex = referencedNode.location().endPosition().index();
            int offset = (startIndex + endIndex) / 2;
            if (localReference) {
                this.localDeclaration.setSelectedRange(offset, 0);
                this.localDeclaration.revealRange(offset, 0);
            } else {
                String moduleName = ((NameIdentifier)this.link.reference().moduleSource().get()).name();
                Optional<IEditorInput> resolve = EclipseVirtualFileSystem.getInstance(this.project).resolveEditorInput(moduleName);
                resolve.ifPresent(file -> SilentRunner.run(() -> {
                    IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)file, (String)"org.mule.tooling.dfl.DFL", (boolean)true);
                    if (openEditor instanceof ITextEditor) {
                        ITextEditor editor = (ITextEditor)openEditor;
                        editor.selectAndReveal(offset, 0);
                    }
                }));
            }
        }
    }
}

