/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.ls;

import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateProposal;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.dfl.ui.contentassist.Stylers;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.ls.DataWeaveTemplateVariable;
import org.mule.tooling.dfl.ui.quickfix.WeaveTextDocumentEclipseAdaptor;
import org.mule.tooling.ui.widgets.image.PluginImageRegistry;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.weave.v2.completion.EclipseTemplate;
import org.mule.weave.v2.completion.EclipseTemplateVariable;
import org.mule.weave.v2.completion.Suggestion;
import org.mule.weave.v2.completion.SuggestionType;
import org.mule.weave.v2.editor.QuickFixAction;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class DataWeaveCompletionItem
extends XtextTemplateProposal
implements ICompletionProposalExtension6 {
    private Suggestion suggestion;

    public DataWeaveCompletionItem(Template template, TemplateContext context, IRegion region, Suggestion suggestion, int index) {
        super(template, context, region, DataWeaveCompletionItem.getImage(suggestion), index * -1);
        this.suggestion = suggestion;
    }

    public String getAdditionalProposalInfo() {
        return DataWeaveCompletionItem.getDocumentation(this.suggestion);
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().toString();
    }

    public StyledString getStyledDisplayString() {
        StyledString displayName = new StyledString(this.suggestion.name());
        String typeText = "";
        if (this.suggestion.wtype().isDefined()) {
            typeText = ((WeaveType)this.suggestion.wtype().get()).toString(false, true);
            displayName.append(" : " + typeText, Stylers.GRAY_STYLER);
        }
        return displayName;
    }

    public static DataWeaveCompletionItem create(IDocument document, Suggestion suggestion, int replacementStart, int length, int i) {
        EclipseTemplateVariable[] variables;
        EclipseTemplate eclipseTemplate = suggestion.template().toEclipseTemplate();
        Template template = new Template(suggestion.name(), "", "", eclipseTemplate.text(), true);
        TemplateContextType templateContextType = new TemplateContextType();
        EclipseTemplateVariable[] eclipseTemplateVariableArray = variables = eclipseTemplate.variables();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseTemplateVariable variable = eclipseTemplateVariableArray[n2];
            templateContextType.addResolver((TemplateVariableResolver)new DataWeaveTemplateVariable(variable));
            ++n2;
        }
        DocumentTemplateContext templateContext = new DocumentTemplateContext(templateContextType, document, replacementStart, length);
        return new DataWeaveCompletionItem(template, (TemplateContext)templateContext, (IRegion)new Region(replacementStart, length), suggestion, i);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        WidgetUtils.getDisplay().asyncExec(() -> {
            QuickFixAction[] insertAction;
            IDocument document = viewer.getDocument();
            TextSelection selection = (TextSelection)viewer.getSelectionProvider().getSelection();
            int documentOffset = selection.getOffset();
            int oldLength = document.get().length();
            WeaveTextDocumentEclipseAdaptor documentAdapter = new WeaveTextDocumentEclipseAdaptor(document);
            QuickFixAction[] quickFixActionArray = insertAction = this.suggestion.insertAction();
            int n = insertAction.length;
            int n2 = 0;
            while (n2 < n) {
                QuickFixAction quickFixAction = quickFixActionArray[n2];
                quickFixAction.run((WeaveTextDocument)documentAdapter);
                ++n2;
            }
            int newLength = viewer.getDocument().get().length();
            viewer.getSelectionProvider().setSelection((ISelection)new TextSelection(documentOffset + (newLength - oldLength), 1));
        });
    }

    public static String getDocumentation(Suggestion suggestion) {
        String documentationHtml = "";
        Option documentation = suggestion.markdownDocumentation();
        if (documentation.isDefined()) {
            documentationHtml = DataWeaveLanguageService.toHtml((String)documentation.get());
        }
        return documentationHtml;
    }

    public static Image getImage(Suggestion suggestion) {
        PluginImageRegistry imageRegistry = DFLExtendedActivator.getInstance().getImages();
        int itemType = suggestion.itemType();
        if (itemType == SuggestionType.Class()) {
            return imageRegistry.getImage("icons/full/obj16/class.png");
        }
        if (itemType == SuggestionType.Keyword()) {
            return imageRegistry.getImage("icons/full/obj16/keyword.png");
        }
        if (itemType == SuggestionType.Function()) {
            return imageRegistry.getImage("icons/full/obj16/function.png");
        }
        if (itemType == SuggestionType.Field()) {
            return imageRegistry.getImage("icons/full/obj16/field.png");
        }
        if (itemType == SuggestionType.Variable()) {
            return imageRegistry.getImage("icons/full/obj16/variable.png");
        }
        return imageRegistry.getImage("icons/full/obj16/field.png");
    }
}

