/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.input;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.flatfile.FlatfileTypeLoader;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.annotations.PropertiesAnnotation;
import org.mule.tooling.mule.json.schemas.FlatFileSchemaUtils;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;

public interface OutputParameterLoader {
    public static final List<MetadataFormat> FLAT_FILE_FORMATS = Arrays.asList(FlatfileTypeLoader.COPYBOOK, FlatfileTypeLoader.FIXED_WIDTH, FlatfileTypeLoader.FLAT_FILE);

    public static OutputParameterLoader forType(MetadataType type) {
        MetadataFormat metadataFormat = type.getMetadataFormat();
        if (FLAT_FILE_FORMATS.contains(metadataFormat)) {
            return new FlatFileLoader(type);
        }
        return new GenericPropertiesLoader(type);
    }

    public void load(IMuleProject var1, Map<String, Object> var2);

    public static class FlatFileLoader
    implements OutputParameterLoader {
        private final MetadataType type;

        public FlatFileLoader(MetadataType type) {
            this.type = type;
        }

        @Override
        public void load(IMuleProject muleProject, Map<String, Object> configuration) {
            this.type.getAnnotation(PathAnnotation.class).ifPresent(path -> configuration.put("schemaPath", path.getPath()));
            this.type.getAnnotation(ElementAnnotation.class).ifPresent(element -> {
                Optional identType = FlatFileSchemaUtils.getStructureComponent((MetadataType)this.type);
                identType.ifPresent(ident -> {
                    String string = configuration.put(ident.getName() + "Ident", element.getElement());
                });
            });
        }
    }

    public static class GenericPropertiesLoader
    implements OutputParameterLoader {
        private final MetadataType type;

        public GenericPropertiesLoader(MetadataType type) {
            this.type = type;
        }

        @Override
        public void load(IMuleProject muleProject, Map<String, Object> configuration) {
            this.type.getAnnotations().stream().filter(PropertiesAnnotation.class::isInstance).map(PropertiesAnnotation.class::cast).findAny().map(PropertiesAnnotation::getProperties).ifPresent(properties -> {
                IWeaveUIModule module = WeaveUIModuleManager.getModuleByMetaDataModel(this.type);
                List readerOptions = WeaveEngineHelperManager.getReaderOptions((String)module.getMimeTypes().get(0));
                Map optionsMap = readerOptions.stream().collect(Collectors.toMap(ModuleOption::getName, Function.identity()));
                for (Map.Entry property : properties.entrySet()) {
                    String propertyValue = (String)property.getValue();
                    ModuleOption moduleOption = (ModuleOption)optionsMap.get(property.getKey());
                    if (moduleOption == null) continue;
                    Object value = moduleOption.isNumber() ? Long.valueOf(propertyValue) : (moduleOption.isBoolean() ? Boolean.valueOf(propertyValue) : propertyValue);
                    configuration.put((String)property.getKey(), value);
                }
            });
        }
    }
}

