/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.input;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.ui.utils.DwMetadataUtils;

public class DefaultMetaDataProvider
implements IMetaDataProvider {
    private MetadataEvent metadata;

    public DefaultMetaDataProvider() {
    }

    public DefaultMetaDataProvider(MetadataEvent metadata) {
        this.metadata = metadata;
    }

    @Override
    public MetadataEvent getMetadata() {
        return this.metadata;
    }

    @Override
    public Optional<MetadataType> getModel(String variableName) {
        if ("payload".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getMessage().getPayload());
        }
        if ("attributes".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getMessage().getAttributes());
        }
        if ("vars".equalsIgnoreCase(variableName)) {
            return Optional.of(this.getMetadata().getVariables());
        }
        return this.getMetadataModel(variableName);
    }

    private Optional<MetadataType> getMetadataModel(String variableName) {
        return DwMetadataUtils.fromOptional(this.getMetadata().getVariables().getFieldByName(variableName));
    }

    public String toString() {
        return "DefaultMetaDataProvider [getMetadata()=" + String.valueOf(this.getMetadata()) + "]";
    }

    @Override
    public boolean isPayload(String variableName) {
        return "payload".equals(variableName);
    }

    @Override
    public boolean isAttributes(String variableName) {
        return "attributes".equals(variableName);
    }

    @Override
    public Map<String, MetadataType> getGlobalBindings() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, MetadataType> getFunctionBindings() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isMetadataAvailable() {
        return true;
    }
}

