/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.input;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.mule.tooling.utils.Pair;

public class DefaultContextMenuProvider
implements IMenuListener {
    private ISelectionProvider selection;
    private Set<String> groupsToAdd = Sets.newHashSet();
    private List<Pair<String, Action>> actionGroupPairs = Lists.newArrayList();
    private List<Pair<String, MenuManager>> subMenus = new ArrayList<Pair<String, MenuManager>>();

    private DefaultContextMenuProvider(ISelectionProvider selection) {
        this.selection = selection;
    }

    public void addAction(Action action) {
        this.actionGroupPairs.add((Pair<String, Action>)Pair.of((Object)"additions", (Object)action));
    }

    public void addAction(Action action, String group) {
        this.actionGroupPairs.add((Pair<String, Action>)Pair.of((Object)group, (Object)action));
    }

    public void addGroup(String groupName) {
        this.groupsToAdd.add(groupName);
    }

    public void addSubMenu(MenuManager manager, String groupName) {
        this.subMenus.add((Pair<String, MenuManager>)Pair.of((Object)groupName, (Object)manager));
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.selection.getSelection().isEmpty()) {
            return;
        }
        this.fillContextMenu(manager);
    }

    protected void fillContextMenu(IMenuManager contextMenu) {
        String group;
        Action action;
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        GEFActionConstants.addStandardActionGroups((IMenuManager)contextMenu);
        for (String string : this.groupsToAdd) {
            contextMenu.add((IContributionItem)new Separator(string));
        }
        for (Pair pair : this.actionGroupPairs) {
            action = (Action)pair.getRight();
            group = (String)pair.getLeft();
            if (!action.isHandled()) continue;
            action.setEnabled(action.isEnabled());
            contextMenu.appendToGroup(group, (IAction)action);
        }
        for (Pair pair : this.subMenus) {
            action = (MenuManager)pair.getRight();
            group = (String)pair.getLeft();
            contextMenu.appendToGroup(group, (IContributionItem)action);
        }
    }

    public static DefaultContextMenuProvider createContextMenu(StructuredViewer viewer) {
        Control control = viewer.getControl();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(control);
        DefaultContextMenuProvider menuProvider = new DefaultContextMenuProvider((ISelectionProvider)viewer);
        menuMgr.addMenuListener((IMenuListener)menuProvider);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        return menuProvider;
    }
}

