/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.hover;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.dfl.ui.utils.XtextDocumentUtils;
import org.mule.weave.v2.hover.HoverMessage;
import scala.Option;

public class DataWeaveHoverProvider
extends DefaultEObjectHoverProvider {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        URI uri = XtextDocumentUtils.getURI((IXtextDocument)textViewer.getDocument());
        DataWeaveLanguageService service = DataWeaveLanguageService.getInstance(DataSenseHolder.getProject(uri.toString()));
        Option<HoverMessage> hover = service.hover(uri.toString(), document, hoverRegion.getOffset(), DataSenseHolder.getCurrentDataSenseProvider(uri.toString()));
        if (hover.isDefined()) {
            HoverMessage hoverMessage = (HoverMessage)hover.get();
            String text = "**Result Type**: ```" + hoverMessage.resultType().toString(false, true) + "```";
            Option markdownDocs = hoverMessage.markdownDocs();
            if (markdownDocs.isDefined()) {
                text = text + "\n\n----\n\n" + (String)markdownDocs.get();
            }
            return DataWeaveLanguageService.toHtml(text);
        }
        return null;
    }

    public IEObjectHoverProvider.IInformationControlCreatorProvider getHoverInfo(final EObject element, final ITextViewer viewer, final IRegion region) {
        return new IEObjectHoverProvider.IInformationControlCreatorProvider2(){

            public IInformationControlCreator getHoverControlCreator() {
                return DataWeaveHoverProvider.this.getHoverControlCreator();
            }

            public Object getInfo() {
                String html = DataWeaveHoverProvider.this.getHoverInfo(viewer, region);
                if (html != null) {
                    StringBuffer buffer = new StringBuffer(html);
                    HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)DataWeaveHoverProvider.this.getStyleSheet());
                    HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                    html = buffer.toString();
                    return new XtextBrowserInformationControlInput(null, element, html, DataWeaveHoverProvider.this.getLabelProvider());
                }
                return null;
            }

            public IInformationControlCreator getInformationPresenterControlCreator() {
                return DataWeaveHoverProvider.this.getInformationPresenterControlCreator();
            }
        };
    }
}

