/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.highlighting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.mule.tooling.dfl.dFL.DFLPackage;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Directive;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.InputDirective;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.SchemaElement;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.dFL.VariableDefinition;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;
import org.mule.tooling.dfl.ui.datasense.SelectionRange;
import org.mule.tooling.dfl.ui.datasense.SelectionRangeManager;
import org.mule.tooling.dfl.ui.highlighting.DFLColors;

public class DFLSemanticHighlighter
implements ISemanticHighlightingCalculator {
    @Inject
    SelectionRangeManager selectionManager;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null) {
            return;
        }
        SelectionRange currentRange = this.selectionManager.getCurrentRange();
        HighlightingSwitch switcher = new HighlightingSwitch(this, acceptor, currentRange);
        TreeIterator iter = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            switcher.doSwitch(current);
            if (cancelIndicator == null || !cancelIndicator.isCanceled()) continue;
            return;
        }
    }

    public INode getFirstFeatureNode(EObject semantic, EStructuralFeature feature) {
        if (feature == null) {
            return NodeModelUtils.findActualNodeFor((EObject)semantic);
        }
        List nodes = NodeModelUtils.findNodesForFeature((EObject)semantic, (EStructuralFeature)feature);
        if (!nodes.isEmpty()) {
            return (INode)nodes.get(0);
        }
        return null;
    }

    private static final class HighlightingSwitch
    extends DFLSwitch<Void> {
        private final IHighlightedPositionAcceptor acceptor;
        private final DFLSemanticHighlighter semanticHighlighter;
        private SelectionRange currentRange;

        public HighlightingSwitch(DFLSemanticHighlighter semanticHighlighter, IHighlightedPositionAcceptor acceptor, SelectionRange currentRange) {
            this.semanticHighlighter = semanticHighlighter;
            this.acceptor = acceptor;
            this.currentRange = currentRange;
        }

        public Void caseVariableReference(VariableReference object) {
            String reference = object.getReference();
            if (reference != null) {
                INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
                this.highlightNode(node, DFLColors.VARIABLE.getId(), reference.length());
            }
            return null;
        }

        public Void caseVariableDefinition(VariableDefinition object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
            this.highlightNode(node, DFLColors.VARIABLE.getId(), object.getName().length());
            return (Void)super.caseVariableDefinition(object);
        }

        private void highlightNode(INode node, String id, int length) {
            if (node != null) {
                this.acceptor.addPosition(node.getOffset(), length, new String[]{id});
            }
        }

        public Void caseNamespaceDirective(NamespaceDirective object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getNamespaceDirective_Name());
            this.highlightNode(node, DFLColors.NAMESPACE.getId());
            node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getNamespaceDirective_Value());
            this.highlightNode(node, DFLColors.NAMESPACE.getId());
            return (Void)super.caseNamespaceDirective(object);
        }

        public Void caseDeclaredNamespace(DeclaredNamespace object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
            this.highlightNode(node, DFLColors.NAMESPACE.getId());
            return (Void)super.caseDeclaredNamespace(object);
        }

        public Void caseOutputDirective(OutputDirective object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getOutputDirective_MimeType());
            this.highlightNode(node, DFLColors.KEYWORD.getId());
            return (Void)super.caseOutputDirective(object);
        }

        public Void caseInputDirective(InputDirective object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getInputDirective_MimeType());
            this.highlightNode(node, DFLColors.KEYWORD.getId());
            return (Void)super.caseInputDirective(object);
        }

        public Void caseTypeReference(TypeReference object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
            this.highlightNode(node, DFLColors.TYPE.getId());
            return (Void)super.caseTypeReference(object);
        }

        public Void caseSchemaElement(SchemaElement object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getSchemaElement_Name());
            this.highlightNode(node, DFLColors.KEY.getId());
            node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, (EStructuralFeature)DFLPackage.eINSTANCE.getSchemaElement_Value());
            this.highlightNode(node, DFLColors.STRING.getId());
            return (Void)super.caseSchemaElement(object);
        }

        public Void caseFunctionParameter(FunctionParameter object) {
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
            this.highlightNode(node, DFLColors.VARIABLE.getId());
            return (Void)super.caseFunctionParameter(object);
        }

        public Void caseKey(Key object) {
            INode node;
            this.highlightNode(node, this.isDirective(node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null)) ? DFLColors.DIRECTIVE.getId() : DFLColors.KEY.getId());
            return (Void)super.caseKey(object);
        }

        public Void caseQuotedStringLiteral(QuotedStringLiteral object) {
            String quoted = object.getValue();
            INode node = this.semanticHighlighter.getFirstFeatureNode((EObject)object, null);
            int interpolation = quoted.indexOf("$(");
            while (interpolation != -1) {
                int fromIndex = interpolation + 2;
                int start = node.getOffset() + fromIndex;
                int end = quoted.indexOf(")", fromIndex);
                int length = end == -1 ? quoted.length() - (fromIndex + 1) : end - fromIndex;
                this.acceptor.addPosition(start, length, new String[]{DFLColors.VARIABLE.getId()});
                interpolation = quoted.indexOf("$(", fromIndex + length);
            }
            return (Void)super.caseQuotedStringLiteral(object);
        }

        private boolean isDirective(INode node) {
            while (!(node == null || node.getParent() == null && node.getSemanticElement() instanceof Document)) {
                if (node.getSemanticElement() instanceof Directive) {
                    return true;
                }
                node = node.getParent();
            }
            return false;
        }

        private void highlightNode(INode node, String id) {
            if (node == null) {
                return;
            }
            if (node instanceof ILeafNode) {
                this.acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{id});
            } else {
                for (ILeafNode leaf : node.getLeafNodes()) {
                    if (leaf.isHidden()) continue;
                    this.acceptor.addPosition(leaf.getOffset(), leaf.getLength(), new String[]{id});
                }
            }
        }
    }
}

