/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.highlighting;

import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.mule.tooling.dfl.ui.highlighting.DFLColorRegistry;
import org.mule.tooling.dfl.ui.highlighting.DFLColors;

public class DFLHighlightingConfiguration
implements IHighlightingConfiguration {
    public static final String KEYWORD_ID = "keyword";
    public static final String PUNCTUATION_ID = "punctuation";
    public static final String COMMENT_ID = "comment";
    public static final String STRING_ID = "string";
    public static final String NUMBER_ID = "number";
    public static final String DEFAULT_ID = "default";
    public static final String INVALID_TOKEN_ID = "error";
    public static final String TASK_ID = "task";
    public static final String VARIABLE = "variable";
    public static final String KEY = "key";
    public static final String DIRECTIVE = "directive";
    public static final String NAMESPACE = "namespace";
    public static final String TYPE = "type";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(KEYWORD_ID, "Keyword", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(PUNCTUATION_ID, "Punctuation character", this.punctuationTextStyle());
        acceptor.acceptDefaultHighlighting(COMMENT_ID, "Comment", this.commentTextStyle());
        acceptor.acceptDefaultHighlighting(TASK_ID, "Task Tag", this.taskTextStyle());
        acceptor.acceptDefaultHighlighting(STRING_ID, "String", this.stringTextStyle());
        acceptor.acceptDefaultHighlighting(NUMBER_ID, "Number", this.numberTextStyle());
        acceptor.acceptDefaultHighlighting(DEFAULT_ID, "Default", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(INVALID_TOKEN_ID, "Invalid Symbol", this.errorTextStyle());
        acceptor.acceptDefaultHighlighting(VARIABLE, "Variable", this.variableTextStyle());
        acceptor.acceptDefaultHighlighting(DIRECTIVE, "Directive", this.directiveTextStyle());
        acceptor.acceptDefaultHighlighting(KEY, "Key", this.keyTextStyle());
        acceptor.acceptDefaultHighlighting(NAMESPACE, "Namespace", this.namespaceTextStyle());
        acceptor.acceptDefaultHighlighting(TYPE, "Type", this.typeTextStyle());
    }

    public TextStyle defaultTextStyle() {
        TextStyle textStyle = new TextStyle();
        return textStyle;
    }

    public TextStyle errorTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }

    private TextStyle namespaceTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.NAMESPACE.getId()));
        return textStyle;
    }

    private TextStyle typeTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.TYPE.getId()));
        return textStyle;
    }

    private TextStyle directiveTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.DIRECTIVE.getId()));
        return textStyle;
    }

    private TextStyle keyTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.KEY.getId()));
        return textStyle;
    }

    public TextStyle numberTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.NUMBER.getId()));
        return textStyle;
    }

    public TextStyle stringTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.STRING.getId()));
        return textStyle;
    }

    public TextStyle commentTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.COMMENT.getId()));
        return textStyle;
    }

    public TextStyle taskTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.TASK.getId()));
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle variableTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.VARIABLE.getId()));
        return textStyle;
    }

    public TextStyle keywordTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(DFLColorRegistry.INSTANCE.getRGB(DFLColors.KEYWORD.getId()));
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle punctuationTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }
}

