/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.highlighting;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.mule.tooling.dfl.ui.highlighting.DFLColors;

public enum DFLColorRegistry {
    INSTANCE;

    private final ColorRegistry colorRegistry = new ColorRegistry();

    private DFLColorRegistry() {
        DFLColors[] values;
        DFLColors[] dFLColorsArray = values = DFLColors.values();
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            DFLColors color = dFLColorsArray[n3];
            this.putInColorRegistry(color.getId(), color.getColor());
            ++n3;
        }
    }

    public Color get(String symbolicName) {
        return this.colorRegistry.get(symbolicName);
    }

    public RGB getRGB(String symbolicName) {
        return this.colorRegistry.getRGB(symbolicName);
    }

    private void putInColorRegistry(String name, RGB color) {
        if (!this.colorRegistry.hasValueFor(name)) {
            this.colorRegistry.put(name, color);
        }
    }
}

