/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.ObjectElement;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class XMLMapAppendAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        KeyValuePairContainer existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair().get();
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        String variableName = GraphicalToolHelper.resolveVariableName(targetInformation, relativeReference);
        FunctionParameter functionParameterObject = DFLFactory.eINSTANCE.createFunctionParameter();
        functionParameterObject.setName(variableName);
        String indexOfVariableName = "indexOf" + StringUtils.capitalize((String)variableName);
        FunctionParameter functionParameterIndex = DFLFactory.eINSTANCE.createFunctionParameter();
        functionParameterIndex.setName(indexOfVariableName);
        QName qName = targetMappingNode.getReference().getQName();
        qName = ScaffoldingHelper.defineNamespace(document, qName);
        StringLiteral keyLiteral = DFLFactory.eINSTANCE.createStringLiteral();
        keyLiteral.setValue(DFLModelHelper.quoteIfNecessary((String)qName.getLocalPart()));
        Key key = DFLFactory.eINSTANCE.createKey();
        key.setValue((KeyExpression)keyLiteral);
        DFLModelHelper.assignNamespace((Key)key, (QName)qName);
        KeyValuePair keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
        keyValuePair.setKey(key);
        MultipleKeyValuePairObj mapLambdaBody = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
        ObjectElements objectElements = DFLFactory.eINSTANCE.createObjectElements();
        objectElements.getObjectElements().add((Object)keyValuePair);
        mapLambdaBody.setPattern((ObjectPattern)objectElements);
        DflFactoryUtils.BinaryFunctionWrapper mapLambda = DflFactoryUtils.createMapLambda();
        mapLambda.setLeft(expression);
        mapLambda.setRight(DflFactoryUtils.createClojureOperator(functionParameterObject, functionParameterIndex, (Expression)mapLambdaBody));
        if (targetMappingNode.isComplexList()) {
            MultipleKeyValuePairObj multipleKeyValuePairObj = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
            keyValuePair.setValue((Expression)multipleKeyValuePairObj);
        } else {
            VariableReference variableReference = DFLFactory.eINSTANCE.createVariableReference();
            variableReference.setReference(variableName);
            keyValuePair.setValue((Expression)variableReference);
        }
        EObject mapContainer = existingKeyValuePairContainer.getEObject().eContainer();
        KeyValuePair previousKeyValuePair = this.findKeyValuePair(mapContainer);
        MultipleKeyValuePairObj previousMultipleKeyValuePairObj = (MultipleKeyValuePairObj)previousKeyValuePair.getValue();
        if (previousMultipleKeyValuePairObj.getPattern() instanceof ObjectElements) {
            EnclosedObjectElement leftAppendOperand;
            int indexOf;
            ObjectElements objectElementsPattern = (ObjectElements)previousMultipleKeyValuePairObj.getPattern();
            if (objectElementsPattern == mapContainer) {
                indexOf = objectElementsPattern.getObjectElements().indexOf((Object)existingKeyValuePairContainer.getEObject());
                ObjectElement leftExpression = (ObjectElement)objectElementsPattern.getObjectElements().get(indexOf);
                DflFactoryUtils.ArrayWrapper array = DflFactoryUtils.createArray();
                MultipleKeyValuePairObj newMultipleKeyValuePairObj = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
                ObjectElements newObjectElementsPattern = DFLFactory.eINSTANCE.createObjectElements();
                newMultipleKeyValuePairObj.setPattern((ObjectPattern)newObjectElementsPattern);
                newObjectElementsPattern.getObjectElements().add((Object)leftExpression);
                array.add((ArrayElement)newMultipleKeyValuePairObj);
                leftAppendOperand = array.get();
            } else {
                Expression previousExpression;
                EObject rootChild = this.findRootChild((EObject)objectElementsPattern, mapContainer);
                indexOf = objectElementsPattern.getObjectElements().indexOf((Object)rootChild);
                ObjectElement objectElement = (ObjectElement)objectElementsPattern.getObjectElements().get(indexOf);
                if (objectElement instanceof Expression) {
                    previousExpression = (Expression)objectElement;
                } else {
                    previousExpression = ((EnclosedObjectElement)objectElement).getExpression();
                    objectElementsPattern.getObjectElements().remove(indexOf);
                }
                leftAppendOperand = DflFactoryUtils.encloseExpressionInObjectElement(previousExpression);
            }
            DflFactoryUtils.BinaryFunctionWrapper appendOperation = DflFactoryUtils.createAppend();
            appendOperation.setLeft((Expression)leftAppendOperand);
            appendOperation.setRight((Expression)DflFactoryUtils.encloseExpressionInObjectElement((Expression)mapLambda.get()));
            objectElementsPattern.getObjectElements().add(indexOf, (Object)DflFactoryUtils.encloseExpressionInObjectElement((Expression)appendOperation.get()));
        }
    }

    private KeyValuePair findKeyValuePair(EObject object) {
        KeyValuePair result = null;
        result = object instanceof KeyValuePair ? (KeyValuePair)object : this.findKeyValuePair(object.eContainer());
        return result;
    }

    private EObject findRootChild(EObject subject, EObject mapContainer) {
        EObject result = mapContainer;
        if (result.eContainer() != subject) {
            result = this.findRootChild(subject, result.eContainer());
        }
        return result;
    }
}

