/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class RootMapAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        DflFactoryUtils.BinaryFunctionWrapper mapLambda = DflFactoryUtils.createMapLambda();
        MultipleKeyValuePairObj mapLambdaBody = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
        FunctionParameter functionParameterObject = DFLFactory.eINSTANCE.createFunctionParameter();
        FunctionParameter functionParameterIndex = DFLFactory.eINSTANCE.createFunctionParameter();
        String variableName = GraphicalToolHelper.resolveVariableName(targetInformation, relativeReference);
        String indexOfVariableName = "indexOf" + StringUtils.capitalize((String)variableName);
        functionParameterObject.setName(variableName);
        functionParameterIndex.setName(indexOfVariableName);
        mapLambda.setLeft(expression);
        mapLambda.setRight(DflFactoryUtils.createClojureOperator(functionParameterObject, functionParameterIndex, (Expression)mapLambdaBody));
        targetInformation.getTargetContainer().addObject((EObject)mapLambda.get(), targetInformation.getTargetContext().getCurrentSegment());
    }
}

