/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import org.apache.commons.lang.StringUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class MapAppendAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MultipleKeyValuePairObj clojureExpression;
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        KeyValuePairContainer existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair().get();
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        DflFactoryUtils.BinaryFunctionWrapper mapLambda = DflFactoryUtils.createMapLambda();
        mapLambda.setLeft(expression);
        FunctionParameter functionParameterObject = DFLFactory.eINSTANCE.createFunctionParameter();
        String variableName = GraphicalToolHelper.resolveVariableName(targetInformation, relativeReference);
        functionParameterObject.setName(variableName);
        FunctionParameter functionParameterIndex = DFLFactory.eINSTANCE.createFunctionParameter();
        String indexOfVariableName = "indexOf" + StringUtils.capitalize((String)variableName);
        functionParameterIndex.setName(indexOfVariableName);
        if (targetMappingNode.isComplexList()) {
            clojureExpression = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
        } else {
            VariableReference variableReference = DFLFactory.eINSTANCE.createVariableReference();
            variableReference.setReference(variableName);
            clojureExpression = variableReference;
        }
        mapLambda.setRight(DflFactoryUtils.createClojureOperator(functionParameterObject, functionParameterIndex, (Expression)clojureExpression));
        DflFactoryUtils.BinaryFunctionWrapper appendOperation = DflFactoryUtils.createAppend();
        appendOperation.setLeft((Expression)DflFactoryUtils.encloseExpressionInObjectElement(existingKeyValuePairContainer.getValue()));
        appendOperation.setRight((Expression)DflFactoryUtils.encloseExpressionInObjectElement((Expression)mapLambda.get()));
        existingKeyValuePairContainer.setValue((Expression)appendOperation.get());
    }
}

