/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.GraphicalToolHelper;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class MapAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        KeyValuePair keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
        Key key = DFLFactory.eINSTANCE.createKey();
        StringLiteral keyLiteral = DFLFactory.eINSTANCE.createStringLiteral();
        QName qName = targetMappingNode.getReference().getQName();
        keyLiteral.setValue(DFLModelHelper.quoteIfNecessary((String)qName.getLocalPart()));
        key.setValue((KeyExpression)keyLiteral);
        keyValuePair.setKey(key);
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        DflFactoryUtils.BinaryFunctionWrapper mapLambda = DflFactoryUtils.createMapLambda();
        mapLambda.setLeft(expression);
        FunctionParameter functionParameterObject = DFLFactory.eINSTANCE.createFunctionParameter();
        FunctionParameter functionParameterIndex = DFLFactory.eINSTANCE.createFunctionParameter();
        String variableName = GraphicalToolHelper.resolveVariableName(targetInformation, relativeReference);
        String indexOfVariableName = "indexOf" + StringUtils.capitalize((String)variableName);
        functionParameterObject.setName(variableName);
        functionParameterIndex.setName(indexOfVariableName);
        if (targetMappingNode.isComplexList()) {
            MultipleKeyValuePairObj mapLambdaBody = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
            mapLambda.setRight(DflFactoryUtils.createClojureOperator(functionParameterObject, functionParameterIndex, (Expression)mapLambdaBody));
        } else {
            VariableReference variableReference = DFLFactory.eINSTANCE.createVariableReference();
            variableReference.setReference(variableName);
            mapLambda.setRight(DflFactoryUtils.createClojureOperator(functionParameterObject, functionParameterIndex, (Expression)variableReference));
        }
        keyValuePair.setValue((Expression)mapLambda.get());
        targetInformation.getTargetContainer().addObject((EObject)keyValuePair, targetInformation.getTargetContext().getCurrentSegment());
    }
}

