/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.AnyDateLiteral;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.ArrayElements;
import org.mule.tooling.dfl.dFL.ArrayPattern;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.DefaultValueExpression;
import org.mule.tooling.dfl.dFL.EnclosedExpression;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.Variable;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;

public final class DflFactoryUtils {
    public static final String BINARY_FUNCTION_MAP = "map";
    public static final String BINARY_FUNCTION_APPEND = "++";
    public static final String BINARY_FUNCTION_FILTER = "filter";
    public static final String BINARY_FUNCTION_DISTINCT_BY = "distinctBy";
    public static final String BINARY_GROUP_BY = "groupBy";
    public static final String BINARY_FUNCTION_REDUCE = "reduce";
    public static final String BINARY_FUNCTION_ORDER_BY = "orderBy";
    public static final String BINARY_FUNCTION_TO = "to";
    public static final String BINARY_FUNCTION_SPLIT_BY = "splitBy";
    public static final String BINARY_FUNCTION_STARTS_WITH = "startsWith";
    public static final String BINARY_FUNCTION_ENDS_WITH = "endsWith";
    public static final String BINARY_FUNCTION_CONTAINS = "contains";
    public static final String BINARY_FUNCTION_MAP_OBJECT = "mapObject";
    public static final String BINARY_FUNCTION_PLUCK = "pluck";
    public static final String BINARY_FUNCTION_WRITE = "write";
    public static final String UNARY_FUNCTION_SIZE_OF = "sizeOf";
    public static final String UNARY_FUNCTION_TRIM = "trim";
    public static final String UNARY_FUNCTION_UPPER = "upper";
    public static final String UNARY_FUNCTION_LOWER = "lower";

    private DflFactoryUtils() {
    }

    public static ClojureOperator createClojureOperator(FunctionParameter param1, FunctionParameter param2, Expression expression) {
        ClojureOperator clojureOperator = DFLFactory.eINSTANCE.createClojureOperator();
        clojureOperator.setParam1(param1);
        clojureOperator.setParam2(param2);
        clojureOperator.setExpression(expression);
        return clojureOperator;
    }

    public static boolean isFunctionNamed(EObject currentObject, String goalFunctionName) {
        Variable functionName;
        if (currentObject instanceof BinaryFunction && (functionName = ((BinaryFunction)currentObject).getFunctionName()) instanceof VariableReference) {
            return goalFunctionName.equals(((VariableReference)functionName).getReference());
        }
        return false;
    }

    public static EnclosedExpression encloseExpression(Expression expression) {
        EnclosedExpression resultExpression;
        if (expression instanceof EnclosedExpression) {
            resultExpression = (EnclosedExpression)expression;
        } else {
            EnclosedExpression enclosedExpression = DFLFactory.eINSTANCE.createEnclosedExpression();
            enclosedExpression.setExpression(expression);
            resultExpression = enclosedExpression;
        }
        return resultExpression;
    }

    public static EnclosedObjectElement encloseExpressionInObjectElement(Expression expression) {
        EnclosedObjectElement resultExpression;
        if (expression instanceof EnclosedObjectElement) {
            resultExpression = (EnclosedObjectElement)expression;
        } else {
            Expression actualExpression = expression instanceof EnclosedExpression ? ((EnclosedExpression)expression).getExpression() : expression;
            EnclosedObjectElement enclosedObjectElement = DFLFactory.eINSTANCE.createEnclosedObjectElement();
            enclosedObjectElement.setExpression(actualExpression);
            resultExpression = enclosedObjectElement;
        }
        return resultExpression;
    }

    public static Expression fromEnclosedExpressionToChild(Expression expression) {
        Expression result = expression;
        while (DflFactoryUtils.isEnclosed((EObject)result)) {
            result = result instanceof EnclosedExpression ? ((EnclosedExpression)result).getExpression() : ((EnclosedObjectElement)result).getExpression();
        }
        return result;
    }

    public static EObject fromEnclosedExpressionToParent(EObject eContainer) {
        EObject result = eContainer;
        while (DflFactoryUtils.isEnclosed(result)) {
            result = result.eContainer();
        }
        return result;
    }

    private static boolean isEnclosed(EObject expression) {
        return expression instanceof EnclosedExpression || expression instanceof EnclosedObjectElement;
    }

    public static IntegerLiteral createZeroLiteral() {
        IntegerLiteral defaultValue = DFLFactory.eINSTANCE.createIntegerLiteral();
        defaultValue.setValue(new BigDecimal(0));
        return defaultValue;
    }

    public static QuotedStringLiteral createEmptyStringLiteral() {
        return DflFactoryUtils.createStringLiteral("");
    }

    public static QuotedStringLiteral createStringLiteral(String content) {
        QuotedStringLiteral defaultValue = DFLFactory.eINSTANCE.createQuotedStringLiteral();
        defaultValue.setValue("\"" + content + "\"");
        return defaultValue;
    }

    public static Expression wrapInDefaultIfNecessary(Expression value, Expression defaultValue) {
        return DflFactoryUtils.hasNonNullReturn(value) ? value : DflFactoryUtils.createDefaultValueExpression(value, defaultValue);
    }

    private static boolean hasNonNullReturn(Expression value) {
        return Arrays.asList(DefaultValueExpression.class, Plus.class).stream().anyMatch(clazz -> clazz.isInstance(DflFactoryUtils.fromEnclosedExpressionToParent((EObject)value))) || DflFactoryUtils.isFunctionNamed(DflFactoryUtils.fromEnclosedExpressionToParent((EObject)value), BINARY_FUNCTION_APPEND);
    }

    public static Expression defaultIfOptionalField(MappingNode field, Expression expression, Expression defaultValue) {
        return field.isRequired() ? expression : DflFactoryUtils.encloseExpressionInObjectElement((Expression)DflFactoryUtils.createDefaultValueExpression(expression, defaultValue));
    }

    private static DefaultValueExpression createDefaultValueExpression(Expression expression, Expression value) {
        DefaultValueExpression defaultValueExpr = DFLFactory.eINSTANCE.createDefaultValueExpression();
        defaultValueExpr.setElement(expression);
        defaultValueExpr.setDefault(value);
        return defaultValueExpr;
    }

    public static Expression defaultValueFor(MappingNode targetMappingNode) {
        Object defaultValue;
        if (targetMappingNode.isString()) {
            defaultValue = DflFactoryUtils.createEmptyStringLiteral();
        } else if (targetMappingNode.isNumber()) {
            defaultValue = DflFactoryUtils.createZeroLiteral();
        } else if (targetMappingNode.isBoolean()) {
            defaultValue = DflFactoryUtils.createTrueLiteral();
        } else if (targetMappingNode.isDate()) {
            AnyDateLiteral dateLiteral = DFLFactory.eINSTANCE.createAnyDateLiteral();
            dateLiteral.setValue("|1815-12-10|");
            defaultValue = dateLiteral;
        } else if (targetMappingNode.isDateTime()) {
            AnyDateLiteral dateLiteral = DFLFactory.eINSTANCE.createAnyDateLiteral();
            dateLiteral.setValue("|1815-12-10T08:15:00|");
            defaultValue = dateLiteral;
        } else if (targetMappingNode.isObject() || targetMappingNode.isRepeatedObject()) {
            MultipleKeyValuePairObj multipleKeyValuePairObj = DFLFactory.eINSTANCE.createMultipleKeyValuePairObj();
            multipleKeyValuePairObj.setPattern((ObjectPattern)DFLFactory.eINSTANCE.createObjectElements());
            defaultValue = multipleKeyValuePairObj;
        } else {
            defaultValue = targetMappingNode.isList() ? DFLFactory.eINSTANCE.createArray() : DFLFactory.eINSTANCE.createNullLiteral();
        }
        return defaultValue;
    }

    private static BooleanLiteral createTrueLiteral() {
        BooleanLiteral booleanLiteral = DFLFactory.eINSTANCE.createBooleanLiteral();
        booleanLiteral.setValue(true);
        return booleanLiteral;
    }

    public static BinaryFunctionWrapper createMapLambda() {
        return DflFactoryUtils.newWrappedBinaryFunction(BINARY_FUNCTION_MAP);
    }

    public static BinaryFunctionWrapper createAppend() {
        return DflFactoryUtils.newWrappedBinaryFunction(BINARY_FUNCTION_APPEND);
    }

    public static BinaryFunctionWrapper newWrappedBinaryFunction(String name) {
        return DflFactoryUtils.wrap(DflFactoryUtils.createBinaryFunction(name));
    }

    private static BinaryFunctionWrapper wrap(BinaryFunction binaryFunction) {
        return new BinaryFunctionWrapper(binaryFunction);
    }

    private static BinaryFunction createBinaryFunction(String name) {
        VariableReference functionName = DFLFactory.eINSTANCE.createVariableReference();
        functionName.setReference(name);
        BinaryFunction binaryFunction = DFLFactory.eINSTANCE.createBinaryFunction();
        binaryFunction.setFunctionName((Variable)functionName);
        return binaryFunction;
    }

    public static ArrayWrapper createArray() {
        Array array = DFLFactory.eINSTANCE.createArray();
        return new ArrayWrapper(array);
    }

    public static ArrayWrapper from(Array array) {
        return new ArrayWrapper(array);
    }

    public static final class ArrayWrapper {
        private final Array array;
        private final List<ArrayElement> elements;

        public ArrayWrapper(Array array) {
            this.array = array;
            this.elements = this.elementsFromArray(array);
        }

        private List<ArrayElement> elementsFromArray(Array array) {
            ArrayList<ArrayElement> elements = new ArrayList<ArrayElement>();
            ArrayElement head = array.getHead();
            if (head != null) {
                elements.add(head);
                ArrayPattern pattern = array.getPattern();
                if (pattern instanceof ArrayElements) {
                    ArrayElements arrayElements = (ArrayElements)pattern;
                    arrayElements.getElements().stream().forEachOrdered(element -> {
                        boolean bl = elements.add((ArrayElement)element);
                    });
                }
            }
            return elements;
        }

        public Array get() {
            if (!this.elements.isEmpty()) {
                Iterator<ArrayElement> iterator = this.elements.iterator();
                this.array.setHead(iterator.next());
                if (iterator.hasNext()) {
                    ArrayElements arrayElements = DFLFactory.eINSTANCE.createArrayElements();
                    iterator.forEachRemaining(element -> {
                        boolean bl = arrayElements.getElements().add(element);
                    });
                    this.array.setPattern((ArrayPattern)arrayElements);
                }
            }
            return this.array;
        }

        public void add(ArrayElement element) {
            this.elements.add(element);
        }

        public List<ArrayElement> getElements() {
            return Collections.unmodifiableList(this.elements);
        }
    }

    public static final class BinaryFunctionWrapper {
        private final BinaryFunction binaryFunction;

        private BinaryFunctionWrapper(BinaryFunction binaryFunction) {
            this.binaryFunction = binaryFunction;
        }

        public void setLeft(Expression left) {
            this.binaryFunction.setElement(left);
        }

        public void setRight(Expression right) {
            ClojureOperatorOrOrExpression createClojureOperatorOrOrExpression = DFLFactory.eINSTANCE.createClojureOperatorOrOrExpression();
            createClojureOperatorOrOrExpression.setOrExpression(right);
            this.binaryFunction.setFunction(createClojureOperatorOrOrExpression);
        }

        public void setRight(ClojureOperator right) {
            ClojureOperatorOrOrExpression createClojureOperatorOrOrExpression = DFLFactory.eINSTANCE.createClojureOperatorOrOrExpression();
            createClojureOperatorOrOrExpression.setClojureOperator(right);
            this.binaryFunction.setFunction(createClojureOperatorOrOrExpression);
        }

        public BinaryFunction get() {
            return this.binaryFunction;
        }
    }
}

