/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.And;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.NullLiteral;
import org.mule.tooling.dfl.dFL.Or;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;

public class AssignmentAppendAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        KeyValuePairContainer existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair().get();
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        expression = this.castingExpression(expression, sourceMappingNode, targetMappingNode);
        Expression value = existingKeyValuePairContainer.getValue();
        if (value instanceof NullLiteral) {
            return;
        }
        if (targetMappingNode.isNumber()) {
            Plus plusOperation = DFLFactory.eINSTANCE.createPlus();
            plusOperation.setLeft((Expression)DflFactoryUtils.encloseExpressionInObjectElement(DflFactoryUtils.wrapInDefaultIfNecessary(value, (Expression)DflFactoryUtils.createZeroLiteral())));
            plusOperation.setRight(DflFactoryUtils.defaultIfOptionalField(sourceMappingNode, expression, (Expression)DflFactoryUtils.createZeroLiteral()));
            existingKeyValuePairContainer.setValue((Expression)plusOperation);
        } else if (targetMappingNode.isBoolean()) {
            And andOperation = DFLFactory.eINSTANCE.createAnd();
            andOperation.setLeft((Expression)(value instanceof Or ? DflFactoryUtils.encloseExpressionInObjectElement(value) : value));
            andOperation.setRight(expression);
            existingKeyValuePairContainer.setValue((Expression)andOperation);
        } else {
            DflFactoryUtils.BinaryFunctionWrapper appendOperation = DflFactoryUtils.createAppend();
            appendOperation.setLeft((Expression)DflFactoryUtils.encloseExpressionInObjectElement(DflFactoryUtils.wrapInDefaultIfNecessary(value, (Expression)DflFactoryUtils.createEmptyStringLiteral())));
            appendOperation.setRight(DflFactoryUtils.defaultIfOptionalField(sourceMappingNode, expression, (Expression)DflFactoryUtils.createEmptyStringLiteral()));
            existingKeyValuePairContainer.setValue((Expression)appendOperation.get());
        }
    }
}

