/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class AssignmentAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        KeyValuePair keyValuePair = DFLFactory.eINSTANCE.createKeyValuePair();
        Key key = DFLFactory.eINSTANCE.createKey();
        StringLiteral keyLiteral = DFLFactory.eINSTANCE.createStringLiteral();
        QName qName = targetMappingNode.getReference().getQName();
        qName = ScaffoldingHelper.defineNamespace(document, qName);
        DFLModelHelper.assignNamespace((Key)key, (QName)qName);
        keyLiteral.setValue(DFLModelHelper.quoteIfNecessary((String)qName.getLocalPart()));
        key.setValue((KeyExpression)keyLiteral);
        keyValuePair.setKey(key);
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        expression = this.castingExpression(expression, sourceMappingNode, targetMappingNode);
        if (targetMappingNode.isRequired() && !sourceMappingNode.isRequired()) {
            expression = DflFactoryUtils.wrapInDefaultIfNecessary(expression, DflFactoryUtils.defaultValueFor(targetMappingNode));
        }
        keyValuePair.setValue(expression);
        targetInformation.getTargetContainer().addObject((EObject)keyValuePair, targetInformation.getTargetContext().getCurrentSegment());
    }
}

