/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.xml.namespace.QName;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.tooling.dfl.dFL.And;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.DFLFactory;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.ui.graphical.references.AbstractReference;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.references.RelativeReference;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AbstractGraphicalAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class AddAttributeAssignmentAction
extends AbstractGraphicalAction {
    @Override
    public void apply(XtextResource state, MappingInformation mappingInformation) {
        this.execute(state, mappingInformation);
    }

    private void execute(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        Document document = (Document)state.getContents().get(0);
        ISegment attributeSegment = targetMappingNode.getReference().getAttributeSegment().get();
        KeyValuePairContainer KeyValuePairContainer2 = targetInformation.getExistingKeyValuePair().get();
        Key key = KeyValuePairContainer2.getKey();
        Attributes attributes = key.getAttributes() != null ? key.getAttributes() : DFLFactory.eINSTANCE.createAttributes();
        AbstractReference relativeReference = RelativeReference.of(sourceMappingNode.getReference(), targetInformation.getTargetContainer().getContextVariables());
        Expression expression = relativeReference.createSelectionExpression(document);
        expression = this.castingExpression(expression, sourceMappingNode, targetMappingNode);
        Optional findResult = Iterables.tryFind((Iterable)attributes.getAttributes(), (Predicate)new AttributePredicate(attributeSegment));
        if (findResult.isPresent()) {
            AttributeElement attributeElement = (AttributeElement)findResult.get();
            if (attributeElement instanceof Attribute) {
                Attribute attribute = (Attribute)attributeElement;
                if (targetMappingNode.isNumber()) {
                    Plus plusOperation = DFLFactory.eINSTANCE.createPlus();
                    plusOperation.setLeft(attribute.getValue());
                    plusOperation.setRight(expression);
                    attribute.setValue((Expression)plusOperation);
                } else if (targetMappingNode.isBoolean()) {
                    And andOperation = DFLFactory.eINSTANCE.createAnd();
                    andOperation.setLeft(attribute.getValue());
                    andOperation.setRight(expression);
                    attribute.setValue((Expression)andOperation);
                } else {
                    DflFactoryUtils.BinaryFunctionWrapper appendOperation = DflFactoryUtils.createAppend();
                    appendOperation.setLeft(attribute.getValue());
                    appendOperation.setRight(expression);
                    attribute.setValue((Expression)appendOperation.get());
                }
            }
        } else {
            Attribute attribute = DFLFactory.eINSTANCE.createAttribute();
            QName qName = ScaffoldingHelper.defineNamespace(document, attributeSegment.getQName());
            DFLModelHelper.assignNamespace((Attribute)attribute, (QName)qName);
            attribute.setName(DFLModelHelper.quoteIfNecessary((String)attributeSegment.getQName().getLocalPart()));
            attribute.setValue(expression);
            attributes.getAttributes().add((Object)attribute);
        }
        key.setAttributes(attributes);
    }

    private static final class AttributePredicate
    implements Predicate<AttributeElement> {
        private ISegment attributeSegment;

        public AttributePredicate(ISegment attributeSegment) {
            this.attributeSegment = attributeSegment;
        }

        public boolean apply(AttributeElement attr) {
            boolean isTheSameAttribute = false;
            if (attr instanceof Attribute) {
                String name = ((Attribute)attr).getName();
                isTheSameAttribute = name != null && name.equals(this.attributeSegment.getQName().getLocalPart());
            }
            return isTheSameAttribute;
        }
    }
}

