/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.graphical.view2code.generation;

import java.util.Optional;
import org.eclipse.xtext.resource.XtextResource;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.tooling.dfl.ui.graphical.references.ISegment;
import org.mule.tooling.dfl.ui.graphical.util.MappingNode;
import org.mule.tooling.dfl.ui.graphical.view2code.KeyValuePairContainer;
import org.mule.tooling.dfl.ui.graphical.view2code.MappingInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.TargetInformation;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AddAttributeAssignmentAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.ArrayAccessorAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.ArrayAccessorAppendAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AssignmentAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.AssignmentAppendAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.FirstAttributeAssignmentAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.MapAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.MapAppendAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.RootAssignmentAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.RootMapAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.XMLMapAction;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.XMLMapAppendAction;

public final class ActionHandler {
    public static void handle(XtextResource state, MappingInformation mappingInformation) {
        MappingNode sourceMappingNode = mappingInformation.getSourceMappingNode();
        MappingNode targetMappingNode = mappingInformation.getTargetMappingNode();
        TargetInformation targetInformation = mappingInformation.getTargetInformation();
        boolean sourceIsTextElement = sourceMappingNode.isTextElement();
        boolean targetIsXml = targetMappingNode.matchRoot(MetadataFormat.XML);
        Optional<KeyValuePairContainer> existingKeyValuePairContainer = targetInformation.getExistingKeyValuePair();
        Optional<ISegment> attributeSegment = targetMappingNode.getReference().getAttributeSegment();
        if (attributeSegment.isPresent() && !existingKeyValuePairContainer.isPresent()) {
            new FirstAttributeAssignmentAction().apply(state, mappingInformation);
        } else if (attributeSegment.isPresent()) {
            new AddAttributeAssignmentAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && targetMappingNode.isList() && targetMappingNode.isRoot()) {
            new RootMapAction().apply(state, mappingInformation);
        } else if (targetMappingNode.isRoot()) {
            new RootAssignmentAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && targetMappingNode.isList() && targetIsXml && !existingKeyValuePairContainer.isPresent()) {
            new XMLMapAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && targetMappingNode.isList() && !existingKeyValuePairContainer.isPresent()) {
            new MapAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && targetMappingNode.isList() && targetIsXml) {
            new XMLMapAppendAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && targetMappingNode.isList()) {
            new MapAppendAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && !targetMappingNode.isList() && !sourceIsTextElement && !existingKeyValuePairContainer.isPresent()) {
            new ArrayAccessorAction().apply(state, mappingInformation);
        } else if (sourceMappingNode.isList() && !targetMappingNode.isList() && !sourceIsTextElement) {
            new ArrayAccessorAppendAction().apply(state, mappingInformation);
        } else if (!existingKeyValuePairContainer.isPresent()) {
            new AssignmentAction().apply(state, mappingInformation);
        } else {
            new AssignmentAppendAction().apply(state, mappingInformation);
        }
    }
}

